/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.waiter;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.watermedia.videolan4j.waiter.BeforeWaiterAbortedException;
import org.watermedia.videolan4j.waiter.ResultStatus;
import org.watermedia.videolan4j.waiter.UnexpectedWaiterErrorException;
import org.watermedia.videolan4j.waiter.UnexpectedWaiterFinishedException;

public abstract class Waiter<C, R> {
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicReference<ResultStatus> resultStatus = new AtomicReference();
    private final AtomicReference<R> result = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean();
    protected final C component;

    public Waiter(C component) {
        this.component = component;
    }

    public final R await() throws InterruptedException, UnexpectedWaiterErrorException, UnexpectedWaiterFinishedException {
        this.startListening(this.component);
        if (this.onBefore(this.component)) {
            this.completionLatch.await();
            switch (this.resultStatus.get()) {
                case NORMAL: {
                    this.onAfter(this.component, this.result.get());
                    return this.result.get();
                }
                case ERROR: {
                    throw new UnexpectedWaiterErrorException();
                }
                case FINISHED: {
                    throw new UnexpectedWaiterFinishedException();
                }
            }
            throw new IllegalStateException("Unexpected result status: " + (Object)((Object)this.resultStatus.get()));
        }
        throw new BeforeWaiterAbortedException();
    }

    protected final void ready() {
        this.ready(null);
    }

    protected final void ready(R result) {
        if (!this.finished.getAndSet(true)) {
            this.result.set(result);
            this.release(ResultStatus.NORMAL);
        }
    }

    protected final void error() {
        this.release(ResultStatus.ERROR);
    }

    protected final void finished() {
        this.release(ResultStatus.FINISHED);
    }

    protected boolean onBefore(C component) {
        return true;
    }

    protected void onAfter(C component, R result) {
    }

    protected abstract void startListening(C var1);

    protected abstract void stopListening(C var1);

    private void release(ResultStatus resultStatus) {
        this.stopListening(this.component);
        this.resultStatus.set(resultStatus);
        this.completionLatch.countDown();
    }
}

