/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base.events;

import org.watermedia.videolan4j.binding.internal.libvlc_event_e;
import org.watermedia.videolan4j.binding.internal.libvlc_event_t;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.base.events.MediaPlayerAudioDeviceEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerAudioVolumeEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerBackwardEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerBufferingEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerChapterChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerCorkedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerESAddedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerESDeletedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerESSelectedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerEncounteredErrorEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerEndReachedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerForwardEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerLengthChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerMediaChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerMutedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerNothingSpecialEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerOpeningEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerPausableChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerPausedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerPlayingEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerPositionChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerReadyEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerScrambledChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerSeekableChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerSnapshotTakenEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerStoppedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerTimeChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerTitleChangedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerUncorkedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerUnmutedEvent;
import org.watermedia.videolan4j.player.base.events.MediaPlayerVoutEvent;

public final class MediaPlayerEventFactory {
    public static MediaPlayerEvent createEvent(libvlc_instance_t libvlcInstance, MediaPlayer mediaPlayer, libvlc_event_t event) {
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaPlayerMediaChanged: {
                return new MediaPlayerMediaChangedEvent(libvlcInstance, mediaPlayer, event);
            }
            case libvlc_MediaPlayerNothingSpecial: {
                return new MediaPlayerNothingSpecialEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerOpening: {
                return new MediaPlayerOpeningEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerBuffering: {
                return new MediaPlayerBufferingEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerPlaying: {
                return new MediaPlayerPlayingEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerPaused: {
                return new MediaPlayerPausedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerStopped: {
                return new MediaPlayerStoppedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerForward: {
                return new MediaPlayerForwardEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerBackward: {
                return new MediaPlayerBackwardEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerEndReached: {
                return new MediaPlayerEndReachedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerEncounteredError: {
                return new MediaPlayerEncounteredErrorEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerTimeChanged: {
                return new MediaPlayerTimeChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerPositionChanged: {
                return new MediaPlayerPositionChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerSeekableChanged: {
                return new MediaPlayerSeekableChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerPausableChanged: {
                return new MediaPlayerPausableChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerTitleChanged: {
                return new MediaPlayerTitleChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerSnapshotTaken: {
                return new MediaPlayerSnapshotTakenEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerLengthChanged: {
                return new MediaPlayerLengthChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerVout: {
                return new MediaPlayerVoutEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerScrambledChanged: {
                return new MediaPlayerScrambledChangedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerESAdded: {
                return new MediaPlayerESAddedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerESDeleted: {
                return new MediaPlayerESDeletedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerESSelected: {
                return new MediaPlayerESSelectedEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerCorked: {
                return new MediaPlayerCorkedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerUncorked: {
                return new MediaPlayerUncorkedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerMuted: {
                return new MediaPlayerMutedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerUnmuted: {
                return new MediaPlayerUnmutedEvent(mediaPlayer);
            }
            case libvlc_MediaPlayerAudioVolume: {
                return new MediaPlayerAudioVolumeEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerAudioDevice: {
                return new MediaPlayerAudioDeviceEvent(mediaPlayer, event);
            }
            case libvlc_MediaPlayerChapterChanged: {
                return new MediaPlayerChapterChangedEvent(mediaPlayer, event);
            }
        }
        return null;
    }

    public static MediaPlayerEvent createMediaPlayerReadyEvent(MediaPlayer mediaPlayer) {
        return new MediaPlayerReadyEvent(mediaPlayer);
    }

    private MediaPlayerEventFactory() {
    }
}

