/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.downloader.request;

import java.io.File;
import java.util.UUID;
import org.watermedia.shaded.kiulian.downloader.downloader.request.Request;
import org.watermedia.shaded.kiulian.downloader.model.Utils;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Format;

public class RequestVideoFileDownload
extends Request<RequestVideoFileDownload, File> {
    private File outputDirectory = new File("videos");
    private boolean overwrite = false;
    private String fileName = UUID.randomUUID().toString();
    private final Format format;

    public RequestVideoFileDownload(Format format) {
        this.format = format;
    }

    public RequestVideoFileDownload saveTo(File directory) {
        this.outputDirectory = directory;
        return this;
    }

    public RequestVideoFileDownload renameTo(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public RequestVideoFileDownload overwriteIfExists(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Format getFormat() {
        return this.format;
    }

    public File getOutputFile() {
        String originalName = Utils.removeIllegalChars(this.fileName);
        String fileName = originalName + "." + this.format.extension().value();
        File outputFile = new File(this.outputDirectory, fileName);
        if (!this.overwrite) {
            int i = 1;
            while (outputFile.exists()) {
                fileName = originalName + "(" + i++ + ")." + this.format.extension().value();
                outputFile = new File(outputFile.getParentFile(), fileName);
            }
        }
        return outputFile;
    }
}

