/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.kiulian.downloader.Config;
import org.watermedia.shaded.kiulian.downloader.cipher.CachedCipherFactory;
import org.watermedia.shaded.kiulian.downloader.downloader.Downloader;
import org.watermedia.shaded.kiulian.downloader.downloader.DownloaderImpl;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestChannelUploads;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchContinuation;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchResult;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSearchable;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestWebpage;
import org.watermedia.shaded.kiulian.downloader.downloader.response.Response;
import org.watermedia.shaded.kiulian.downloader.downloader.response.ResponseImpl;
import org.watermedia.shaded.kiulian.downloader.extractor.ExtractorImpl;
import org.watermedia.shaded.kiulian.downloader.model.Utils;
import org.watermedia.shaded.kiulian.downloader.model.playlist.PlaylistInfo;
import org.watermedia.shaded.kiulian.downloader.model.search.SearchResult;
import org.watermedia.shaded.kiulian.downloader.model.subtitles.SubtitlesInfo;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoInfo;
import org.watermedia.shaded.kiulian.downloader.parser.Parser;
import org.watermedia.shaded.kiulian.downloader.parser.ParserImpl;

public class YoutubeDownloader {
    private final Config config;
    private final Downloader downloader;
    private final Parser parser;

    public YoutubeDownloader() {
        this(Config.buildDefault());
    }

    public YoutubeDownloader(Config config) {
        this.config = config;
        this.downloader = new DownloaderImpl(config);
        this.parser = new ParserImpl(config, this.downloader, new ExtractorImpl(this.downloader), new CachedCipherFactory(this.downloader));
    }

    public YoutubeDownloader(Config config, Downloader downloader) {
        this(config, downloader, new ParserImpl(config, downloader, new ExtractorImpl(downloader), new CachedCipherFactory(downloader)));
    }

    public YoutubeDownloader(Config config, Downloader downloader, Parser parser) {
        this.config = config;
        this.parser = parser;
        this.downloader = downloader;
    }

    public Config getConfig() {
        return this.config;
    }

    public Response<VideoInfo> getVideoInfo(RequestVideoInfo request) {
        return this.parser.parseVideo(request);
    }

    public Response<List<SubtitlesInfo>> getSubtitlesInfo(RequestSubtitlesInfo request) {
        return this.parser.parseSubtitlesInfo(request);
    }

    public Response<PlaylistInfo> getChannelUploads(RequestChannelUploads request) {
        return this.parser.parseChannelsUploads(request);
    }

    public Response<PlaylistInfo> getPlaylistInfo(RequestPlaylistInfo request) {
        return this.parser.parsePlaylist(request);
    }

    public Response<SearchResult> search(RequestSearchResult request) {
        return this.parser.parseSearchResult(request);
    }

    public Response<SearchResult> searchContinuation(RequestSearchContinuation request) {
        return this.parser.parseSearchContinuation(request);
    }

    public Response<SearchResult> search(RequestSearchable request) {
        return this.parser.parseSearcheable(request);
    }

    public Response<File> downloadVideoFile(RequestVideoFileDownload request) {
        File outDir = request.getOutputDirectory();
        try {
            Utils.createOutDir(outDir);
        }
        catch (IOException e) {
            return ResponseImpl.error(e);
        }
        return this.downloader.downloadVideoAsFile(request);
    }

    public Response<Void> downloadVideoStream(RequestVideoStreamDownload request) {
        return this.downloader.downloadVideoAsStream(request);
    }

    public Response<String> downloadSubtitle(RequestWebpage request) {
        return this.downloader.downloadWebpage(request);
    }
}

