/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.NetTool;

public class LightshotPatch
extends AbstractPatch {
    private static final Pattern HTML_PATTERN = Pattern.compile("<img[^>]*class=\"no-click screenshot-image\"[^>]*src=\"(https://[^\"]+)\"");

    @Override
    public String platform() {
        return "Lightshot";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        return host != null && host.equals("prnt.sc");
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, prefQuality);
        try {
            String html = this.connectToLightshot(uri);
            Matcher matcher = HTML_PATTERN.matcher(html);
            if (matcher.find()) {
                return new AbstractPatch.Result(new URI(matcher.group(1)), false, false);
            }
            throw new NullPointerException("No match was found");
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }

    public String connectToLightshot(URI url) throws IOException {
        HttpURLConnection conn = NetTool.connectToHTTP(url, "GET");
        int code = conn.getResponseCode();
        switch (code) {
            case 404: {
                throw new NullPointerException("Image was not found");
            }
            case 401: 
            case 403: {
                throw new UnsupportedOperationException("Access denied by Lightshot");
            }
        }
        if (code != 200) {
            throw new UnsupportedOperationException("Lightshot responses with a unexpected status code: " + code);
        }
        try {
            String string;
            block14: {
                InputStream in = conn.getInputStream();
                try {
                    string = new String(DataTool.readAllBytes(in), StandardCharsets.UTF_8);
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }
}

