/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.wide;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class WideDefaultBogeyVisual
implements BogeyVisual {
    private final TransformedInstance[] wheels = new TransformedInstance[3];
    private final TransformedInstance frame;
    private final TransformedInstance[] shafts = new TransformedInstance[2];

    public WideDefaultBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.CR_WIDE_BOGEY_WHEELS)).createInstances((Instance[])this.wheels);
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.WIDE_DEFAULT_FRAME)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.shafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shafts[i].translate(-0.5, 0.375, (double)(0.5f + (float)(i * -2)))).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.setChanged();
        for (int side = -1; side < 2; ++side) {
            ((TransformedInstance)((TransformedInstance)this.wheels[side + 1].translate(0.0, 0.875, (double)side * 1.5)).rotateXDegrees(wheelAngle)).setChanged();
        }
    }

    public void hide() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        this.frame.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.shafts) {
            shaft.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
        for (TransformedInstance shaft : this.shafts) {
            shaft.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
        for (TransformedInstance shaft : this.shafts) {
            consumer.accept((Instance)shaft);
        }
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
        for (TransformedInstance shaft : this.shafts) {
            shaft.delete();
        }
    }
}

