/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.wide;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class WideComicallyLargeScotchYokeBogeyVisual
implements BogeyVisual {
    private final TransformedInstance wheel;
    private final TransformedInstance frame;
    private final TransformedInstance pins;
    private final TransformedInstance pistons;
    private final TransformedInstance[] primaryShafts = new TransformedInstance[2];
    private final TransformedInstance[] secondaryShafts = new TransformedInstance[4];

    public WideComicallyLargeScotchYokeBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.WIDE_COMICALLY_LARGE_WHEELS)).createInstance();
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.WIDE_COMICALLY_LARGE_FRAME)).createInstance();
        this.pins = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.WIDE_COMICALLY_LARGE_PINS)).createInstance();
        this.pistons = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.WIDE_COMICALLY_LARGE_PISTONS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.primaryShafts);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.secondaryShafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.primaryShafts[i].translate(-0.5, 0.25, (double)(i * -1))).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        for (int i : Iterate.zeroAndOne) {
            for (int side : Iterate.zeroAndOne) {
                ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShafts[i + side * 2].translate((double)(-1 + side), 0.25, 0.625 + (double)i * -2.25)).center()).rotateXDegrees(wheelAngle)).uncenter()).setChanged();
            }
        }
        ((TransformedInstance)this.frame.translate(0.0, 0.25, 0.0)).setChanged();
        ((TransformedInstance)this.pistons.translate(0.0, 1.5, 0.5625 * Math.sin(AngleHelper.rad((double)wheelAngle)))).setChanged();
        ((TransformedInstance)((TransformedInstance)this.wheel.translate(0.0, 1.5, 0.0)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.0f, 0.0f).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pins.translate(0.0, 1.5, 0.0)).rotateXDegrees(wheelAngle)).translate(0.0, 0.5625, 0.0)).rotateXDegrees(-wheelAngle)).setChanged();
    }

    public void hide() {
        this.wheel.setZeroTransform().setChanged();
        this.frame.setZeroTransform().setChanged();
        this.pins.setZeroTransform().setChanged();
        this.pistons.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        this.wheel.light(packedLight);
        this.frame.light(packedLight);
        this.pins.light(packedLight);
        this.pistons.light(packedLight);
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.wheel);
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.pins);
        consumer.accept((Instance)this.pistons);
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            consumer.accept((Instance)shaft);
        }
    }

    public void delete() {
        this.wheel.delete();
        this.frame.delete();
        this.pins.delete();
        this.pistons.delete();
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.delete();
        }
    }
}

