/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class SingleaxleBogeyVisual
implements BogeyVisual {
    private final TransformedInstance wheel;
    private final TransformedInstance frame;
    private final boolean inContraption;

    public SingleaxleBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SMALL_BOGEY_WHEELS)).createInstance();
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();
        this.inContraption = inContraption;
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        ((TransformedInstance)this.wheel.translate(0.0f, 0.75f, 0.0f).rotateXDegrees(wheelAngle)).setChanged();
        this.frame.setChanged();
    }

    public void hide() {
        this.wheel.setZeroTransform().setChanged();
        this.frame.setZeroTransform().setChanged();
    }

    public void updateLight(int packedLight) {
        this.wheel.light(packedLight);
        this.frame.light(packedLight);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.wheel);
        consumer.accept((Instance)this.frame);
    }

    public void delete() {
        this.wheel.delete();
        this.frame.delete();
    }
}

