/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class MediumQuadrupleWheelVisual
implements BogeyVisual {
    private final TransformedInstance[] wheels = new TransformedInstance[4];
    private final TransformedInstance frame;
    private final TransformedInstance[] shafts = new TransformedInstance[4];

    public MediumQuadrupleWheelVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MEDIUM_QUADRUPLE_WHEEL_FRAME)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MEDIUM_SHARED_WHEELS)).createInstances((Instance[])this.wheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.shafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        int side;
        for (side = 0; side < 4; ++side) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shafts[side].translate(-0.5f, 0.31f, 1.0f + (float)(side * -1)).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.setChanged();
        for (side = -1; side < 3; ++side) {
            ((TransformedInstance)((TransformedInstance)this.wheels[side + 1].translate(0.0, 0.8125, -0.75 + (double)side * 1.5)).rotateXDegrees(wheelAngle)).translate(0.0f, -0.8125f, 0.0f).setChanged();
        }
    }

    public void hide() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        this.frame.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.shafts) {
            shaft.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
        for (TransformedInstance shaft : this.shafts) {
            shaft.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
        for (TransformedInstance shaft : this.shafts) {
            consumer.accept((Instance)shaft);
        }
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
        for (TransformedInstance shaft : this.shafts) {
            shaft.delete();
        }
    }
}

