/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.large;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class LargeCreateStyled0100Visual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance piston;
    private final TransformedInstance blindWheel;
    private final TransformedInstance[] secondaryWheels = new TransformedInstance[2];
    private final TransformedInstance[] wheels = new TransformedInstance[2];
    private final TransformedInstance[] pins = new TransformedInstance[5];
    private final TransformedInstance[] primaryShafts = new TransformedInstance[2];
    private final TransformedInstance[] secondaryShafts = new TransformedInstance[6];

    public LargeCreateStyled0100Visual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LARGE_CREATE_STYLED_0_10_0_FRAME)).createInstance();
        this.piston = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LARGE_CREATE_STYLED_0_10_0_PISTON)).createInstance();
        this.blindWheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LC_STYLE_FULL_BLIND_WHEELS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LC_STYLE_SEMI_BLIND_WHEELS)).createInstances((Instance[])this.secondaryWheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.LARGE_BOGEY_WHEELS)).createInstances((Instance[])this.wheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.BOGEY_PIN)).createInstances((Instance[])this.pins);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.primaryShafts);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.secondaryShafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.primaryShafts[(side + 1) / 2].translate(-0.5, 0.25, -0.5 + (double)side * 4.3675)).center()).rotateXDegrees(wheelAngle)).uncenter()).setChanged();
        }
        for (int side = -3; side < 3; ++side) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShafts[side + 3].translate(-0.5, 0.25, (double)-1.3f + (double)side * -1.6)).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.setChanged();
        ((TransformedInstance)this.piston.translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad((double)wheelAngle)))).setChanged();
        ((TransformedInstance)this.blindWheel.translate(0.0f, 1.0f, 0.0f).rotateXDegrees(wheelAngle)).translate(0.0f, -1.0f, 0.0f).setChanged();
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)this.wheels[(side + 1) / 2].translate(0.0, 1.0, (double)side * 3.3684)).rotateXDegrees(wheelAngle)).setChanged();
            ((TransformedInstance)((TransformedInstance)this.secondaryWheels[(side + 1) / 2].translate(0.0, 1.0, (double)side * 1.684)).rotateXDegrees(wheelAngle)).translate(0.0f, -1.0f, 0.0f).setChanged();
        }
        for (int side = -2; side < 3; ++side) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pins[side + 2].translate(0.0, 1.0, (double)side * 1.6842)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f).rotateXDegrees(-wheelAngle)).setChanged();
        }
    }

    public void hide() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        this.frame.setZeroTransform().setChanged();
        this.piston.setZeroTransform().setChanged();
        this.blindWheel.setZeroTransform().setChanged();
        for (TransformedInstance secondaryWheel : this.secondaryWheels) {
            secondaryWheel.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance pin : this.pins) {
            pin.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
        this.piston.light(packedLight);
        this.blindWheel.light(packedLight);
        for (TransformedInstance secondaryWheel : this.secondaryWheels) {
            secondaryWheel.light(packedLight);
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance pin : this.pins) {
            pin.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.piston);
        consumer.accept((Instance)this.blindWheel);
        for (TransformedInstance secondaryWheel : this.secondaryWheels) {
            consumer.accept((Instance)secondaryWheel);
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance pin : this.pins) {
            consumer.accept((Instance)pin);
        }
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
        this.piston.delete();
        this.blindWheel.delete();
        for (TransformedInstance secondaryWheel : this.secondaryWheels) {
            secondaryWheel.delete();
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance pin : this.pins) {
            pin.delete();
        }
    }
}

