/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.handcar.ik.DoubleArmIK;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HandcarBogeyVisual
implements BogeyVisual {
    private final TransformedInstance coupling;
    private final TransformedInstance frame;
    private final TransformedInstance handleFirstPerson;
    private final TransformedInstance handle;
    private final TransformedInstance largeCog;
    private final TransformedInstance smallCog;
    private final TransformedInstance[] wheels = new TransformedInstance[2];

    public HandcarBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.coupling = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_WHEELS)).createInstance();
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_FRAME)).createInstance();
        this.handleFirstPerson = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_WHEEL_PINS)).createInstance();
        this.handle = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_PISTONS)).createInstance();
        this.largeCog = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_PISTONS)).createInstance();
        this.smallCog = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_PISTONS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.wheels);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        double couple_r = 0.1875 * (double)Mth.f_13994_;
        double couple_degrees = (double)(-wheelAngle / 2.0f) - 22.5;
        float couple_radians = (float)(couple_degrees * 0.01745329238474369);
        double couple_x = couple_r * (double)Mth.m_14031_((float)couple_radians);
        double couple_y = couple_r * (double)Mth.m_14089_((float)couple_radians);
        Vec3 coupling_pos = new Vec3(0.109375, 0.75 + couple_y, -0.21875 + couple_x);
        Vec2 upperVec2 = new Vec2(0.0f, 2.4375f);
        Vec2 couplingVec2 = new Vec2((float)coupling_pos.f_82481_, (float)coupling_pos.f_82480_);
        Vec2 hingeOffset = DoubleArmIK.calculateJointOffset(upperVec2, couplingVec2, 0.875, 1.125);
        Vec2 hingePos2 = hingeOffset.m_165910_(couplingVec2);
        double couplingAngle = Mth.m_14136_((double)hingeOffset.f_82471_, (double)hingeOffset.f_82470_);
        Vec2 handle_offset = hingePos2.m_165910_(upperVec2.m_165913_());
        double handleAngle = Mth.m_14136_((double)handle_offset.f_82471_, (double)handle_offset.f_82470_);
        this.frame.translate(0.0f, 0.3125f, 0.0f).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.handle.translateY(2.4375f)).rotateZDegrees(180.0f)).rotateXDegrees((float)(handleAngle - Math.toRadians(57.5)))).translateY(-2.125f)).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.handleFirstPerson.translateY(2.4375f)).rotateZDegrees(180.0f)).rotateXDegrees((float)(handleAngle - Math.toRadians(57.5)))).translateY(-2.125f)).setChanged();
        ((TransformedInstance)((TransformedInstance)this.coupling.translate(coupling_pos)).rotateXDegrees((float)(-(couplingAngle - 1.5707963705062866)))).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.largeCog.translate(-0.5, 0.75, -0.21875)).rotateXDegrees(-wheelAngle / 2.0f + 22.5f)).rotateZDegrees(90.0f)).translate(0.0f, -0.4375f, 0.0f).setChanged();
        ((TransformedInstance)((TransformedInstance)this.smallCog.translate(-0.5f, 0.75f, -1.0f).rotateXDegrees(wheelAngle)).rotateZDegrees(90.0f)).translate(0.0f, -0.4375f, 0.0f).setChanged();
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)this.wheels[(side + 1) / 2].translate(0.0f, 0.75f, (float)side).rotateXDegrees(wheelAngle)).translate(0.0f, -0.75f, 0.0f).setChanged();
        }
    }

    public void hide() {
        this.frame.setZeroTransform().setChanged();
        this.handle.setZeroTransform().setChanged();
        this.handleFirstPerson.setZeroTransform().setChanged();
        this.coupling.setZeroTransform().setChanged();
        this.largeCog.setZeroTransform().setChanged();
        this.smallCog.setZeroTransform().setChanged();
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
        this.handle.light(packedLight);
        this.handleFirstPerson.light(packedLight);
        this.coupling.light(packedLight);
        this.largeCog.light(packedLight);
        this.smallCog.light(packedLight);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.handle);
        consumer.accept((Instance)this.handleFirstPerson);
        consumer.accept((Instance)this.coupling);
        consumer.accept((Instance)this.largeCog);
        consumer.accept((Instance)this.smallCog);
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
        this.handle.delete();
        this.handleFirstPerson.delete();
        this.coupling.delete();
        this.largeCog.delete();
        this.smallCog.delete();
    }
}

