/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.mixin;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.weido.create_bb.data.BogieFunctionality;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={InvisibleBogeyBlock.class})
public abstract class InvisibleBogeyBlockMixin
extends AbstractBogeyBlock<InvisibleBogeyBlockEntity>
implements IBE<InvisibleBogeyBlockEntity>,
ProperWaterloggedBlock,
SpecialBlockItemRequirement {
    protected InvisibleBogeyBlockMixin(BlockBehaviour.Properties props) {
        super(props, BogeySizes.SMALL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult onInteractWithBogey(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return BogieFunctionality.BogeyMenuInteraction(level, pos, player, hand);
    }

    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return TrackMaterial.TrackType.STANDARD;
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        CarriageBogey bogey;
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey carriageBogey = bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        if (point.edge == null) {
            return false;
        }
        return point.edge.getTrackMaterial().trackType != this.getTrackType(bogey.getStyle()) && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.WIDE_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.NARROW_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.MONORAIL;
    }

    public Set<TrackMaterial.TrackType> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of((Object)this.getTrackType(style), (Object)CRTrackMaterials.CRTrackType.WIDE_GAUGE, (Object)CRTrackMaterials.CRTrackType.NARROW_GAUGE, (Object)CRTrackMaterials.CRTrackType.MONORAIL);
    }

    public double getWheelPointSpacing() {
        return 2.0;
    }

    public double getWheelRadius() {
        return 0.40625;
    }

    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, 0.21875, 1.0);
    }

    public BogeyStyle getDefaultStyle() {
        return CRBogeyStyles.INVISIBLE;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public Class<InvisibleBogeyBlockEntity> getBlockEntityClass() {
        return InvisibleBogeyBlockEntity.class;
    }

    public BlockEntityType<? extends InvisibleBogeyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.INVISIBLE_BOGEY.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CRShapes.INVISIBLE_BOGEY;
    }
}

