/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.packets;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.weido.create_bb.data.compat.steamnrails.MixinOverlapFix;
import com.weido.create_bb.data.menu.Entry.StyleMenuHandler;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BogieStylePacket
extends SimplePacketBase {
    private final BogeyStyle style;
    @Nullable
    private final BogeySizes.BogeySize size;
    @Nullable
    private final BlockPos pos;

    public BogieStylePacket(@NotNull BogeyStyle style, @Nullable BogeySizes.BogeySize size, @Nullable BlockPos pos) {
        this.style = style;
        this.size = size;
        this.pos = pos;
    }

    public BogieStylePacket(FriendlyByteBuf buf) {
        ResourceLocation styleLoc = buf.m_130281_();
        this.style = AllBogeyStyles.BOGEY_STYLES.getOrDefault(styleLoc, AllBogeyStyles.STANDARD);
        if (buf.readBoolean()) {
            ResourceLocation sizeLoc = buf.m_130281_();
            this.size = (BogeySizes.BogeySize)BogeySizes.all().get(sizeLoc);
        } else {
            this.size = null;
        }
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.style.id);
        buf.writeBoolean(this.size != null);
        if (this.size != null) {
            buf.m_130085_(this.size.id());
        }
        buf.writeBoolean(this.pos != null);
        if (this.pos != null) {
            buf.m_130064_(this.pos);
        }
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            if (this.pos != null && level.m_7702_(this.pos) instanceof AbstractBogeyBlockEntity) {
                AbstractBogeyBlock newBlock = this.style.getBlockForSize(this.size);
                BlockState newState = (BlockState)newBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)((Direction.Axis)level.m_8055_(this.pos).m_61143_((Property)BlockStateProperties.f_61364_)));
                level.m_7731_(this.pos, newState, 3);
                BlockEntity patt3197$temp = level.m_7702_(this.pos);
                if (patt3197$temp instanceof AbstractBogeyBlockEntity) {
                    AbstractBogeyBlockEntity newBe = (AbstractBogeyBlockEntity)patt3197$temp;
                    newBe.setBogeyStyle(this.style);
                }
            }
            if (this.size != null) {
                if (ModList.get().isLoaded("railways")) {
                    MixinOverlapFix.addStyle(player.m_20148_(), Pair.of((Object)this.style, (Object)this.size));
                } else {
                    StyleMenuHandler.addStyle(player.m_20148_(), (Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)this.style, (Object)this.size));
                }
            }
        });
        return true;
    }
}

