/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.math;

import net.minecraft.util.Mth;

public class MathCalculations {
    public static Point calculateIntersection(Point point1, float radius1, Point point2, float radius2, boolean upperIntersection) {
        float distance = MathCalculations.calculateDistance(point2, point1);
        float distanceSquared = Mth.m_14207_((float)distance);
        float r1Squared = Mth.m_14207_((float)radius1);
        float r2Squared = Mth.m_14207_((float)radius2);
        float x_offset = (distanceSquared - r2Squared + r1Squared) / (2.0f * distance);
        float y_offset = (float)(upperIntersection ? -1 : 1) * (1.0f / (2.0f * distance)) * Mth.m_14116_((float)(4.0f * distanceSquared * r1Squared - Mth.m_14207_((float)(distanceSquared - r2Squared + r1Squared))));
        float angle = MathCalculations.calculateAngle(point2, point1);
        float sinAngle = Mth.m_14031_((float)angle);
        float cosAngle = Mth.m_14089_((float)angle);
        float x = cosAngle * x_offset - sinAngle * y_offset + point1.x;
        float y = sinAngle * x_offset + cosAngle * y_offset + point1.y;
        return new Point(x, y);
    }

    public static Point calculateXIntersection(Point point, float radius, float targetY, boolean upperIntersection) {
        float dy = point.y - targetY;
        float x_offset = Mth.m_14116_((float)(Mth.m_14207_((float)radius) - Mth.m_14207_((float)dy)));
        return new Point(point.x + (upperIntersection ? x_offset : -x_offset), targetY);
    }

    public static float calculateAngle(Point point2, Point point1) {
        float dx = point2.x - point1.x;
        float dy = point2.y - point1.y;
        return (float)Mth.m_14136_((double)dy, (double)dx);
    }

    public static Point calculateConnectPoint(Point point2, Point point1, float connectionPoint) {
        float ratio = connectionPoint / MathCalculations.calculateDistance(point2, point1);
        return new Point(point1.x + ratio * (point2.x - point1.x), point1.y + ratio * (point2.y - point1.y));
    }

    public static float calculateDistance(Point point2, Point point1) {
        float dx = point2.x - point1.x;
        float dy = point2.y - point1.y;
        return Mth.m_14116_((float)(Mth.m_14207_((float)dx) + Mth.m_14207_((float)dy)));
    }

    public record Point(float x, float y) {
    }
}

