/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.weido.create_bb.blocks.BBBogieBlockEntity;
import com.weido.create_bb.data.packets.BogieMenuPacket;
import com.weido.create_bb.registry.BogiePackets;
import java.util.Random;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class BogieFunctionality {
    public static InteractionResult BogieRotationInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        BBBogieBlockEntity bogie;
        BBBogieBlockEntity be;
        if (BogieFunctionality.isInvalidInteraction(player, hand)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        BBBogieBlockEntity bBBogieBlockEntity = be = blockEntity instanceof BBBogieBlockEntity ? (bogie = (BBBogieBlockEntity)blockEntity) : null;
        if (be == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return BogieFunctionality.openMenu(level, player, pos);
        }
        return BogieFunctionality.rotateBogie(state, level, pos, player, be);
    }

    public static InteractionResult BogeyMenuInteraction(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (BogieFunctionality.isInvalidInteraction(player, hand)) {
            return InteractionResult.PASS;
        }
        AbstractBogeyBlockEntity be = (AbstractBogeyBlockEntity)level.m_7702_(pos);
        if (be == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        return BogieFunctionality.openMenu(level, player, pos);
    }

    private static boolean isInvalidInteraction(Player player, InteractionHand hand) {
        return hand != InteractionHand.MAIN_HAND || !player.m_21120_(hand).m_41619_();
    }

    private static InteractionResult openMenu(Level level, Player player, BlockPos pos) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BogiePackets.getChannel().send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new BogieMenuPacket(pos));
        }
        AllSoundEvents.SCROLL_VALUE.playOnServer(level, (Vec3i)pos, 1.0f, 1.0f);
        return InteractionResult.CONSUME;
    }

    private static InteractionResult rotateBogie(BlockState state, Level level, BlockPos pos, Player player, BBBogieBlockEntity be) {
        boolean newDirection;
        boolean isNewBogie;
        if (level.f_46443_) {
            return InteractionResult.FAIL;
        }
        CompoundTag bogieData = be.getBogeyData();
        Direction assemblyDirection = (Direction)NBTHelper.readEnum((CompoundTag)bogieData, (String)"AssemblyDirection", Direction.class);
        boolean bl = isNewBogie = !bogieData.m_128441_("IsForwards");
        boolean bl2 = isNewBogie ? BogieFunctionality.isDirectionPositive(assemblyDirection) : (newDirection = !bogieData.m_128471_("IsForwards"));
        if (!bogieData.m_128441_("AssemblyDirection")) {
            NBTHelper.writeEnum((CompoundTag)bogieData, (String)"AssemblyDirection", (Enum)Direction.SOUTH);
        }
        if (level instanceof ServerLevel) {
            level.m_7260_(pos, state, state, 3);
            level.m_6289_(pos, state.m_60734_());
        }
        bogieData.m_128379_("IsForwards", newDirection);
        be.setBogeyData(bogieData);
        be.m_6596_();
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, new Random().nextFloat() + 0.5f);
        player.m_5661_((Component)Component.m_237115_((String)"create_bb.tooltips.rotation"), true);
        return InteractionResult.CONSUME;
    }

    private static boolean isDirectionPositive(Direction direction) {
        return direction == Direction.NORTH || direction == Direction.WEST || direction == Direction.UP;
    }
}

