/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundFilterTagsPacket {
    private final int slot;
    private final List<String> tags;

    public ServerboundFilterTagsPacket(int slot, List<String> tags) {
        this.slot = slot;
        this.tags = tags;
    }

    public static ServerboundFilterTagsPacket decode(FriendlyByteBuf buffer) {
        int slot = buffer.readInt();
        List tags = buffer.m_236845_(FriendlyByteBuf::m_130277_);
        return new ServerboundFilterTagsPacket(slot, tags);
    }

    public static void encode(ServerboundFilterTagsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slot);
        buffer.m_236828_(message.tags, FriendlyByteBuf::m_130070_);
    }

    public static void handle(ServerboundFilterTagsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                BackpackBaseMenu menu;
                BackpackWrapper wrapper;
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt1693$temp = serverPlayer.f_36096_;
                if (patt1693$temp instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)patt1693$temp).getWrapper()).getUpgrades().getStackInSlot(message.slot).m_41619_()) {
                    Object patt2349$temp;
                    ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot).m_41777_();
                    NbtHelper.set(upgradeStack, "FilterTags", message.tags);
                    wrapper.getUpgrades().setStackInSlot(message.slot, upgradeStack);
                    if (((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).isPresent() && (patt2349$temp = ((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).get()) instanceof FilterUpgradeBase) {
                        FilterUpgradeBase filterUpgrade = (FilterUpgradeBase)patt2349$temp;
                        ((FilterSettingsBase)filterUpgrade.getFilterSettings()).updateFilterTags(message.tags);
                    }
                    menu.getWrapper().saveHandler.run();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

