/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SupporterBadgeWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackSettingsScreen
extends AbstractBackpackScreen<BackpackSettingsMenu>
implements MenuAccess<BackpackSettingsMenu> {
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, Inventory inventory, Component component) {
        super(backpackSettingsMenu, inventory, backpackSettingsMenu.getWrapper().getBackpackScreenTitle());
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.lastMemorySlots);
        this.visibility = NbtHelper.getOrDefault(this.wrapper.getBackpackStack(), "IsVisible", true);
        this.f_97728_ = 8;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initWidgets();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.isScrollable = false;
        this.recalculate();
        this.m_7856_();
        ((BackpackSettingsMenu)this.m_6262_()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    public void recalculate() {
        boolean wideTexture;
        this.m_169413_();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.f_97726_ = wideTexture ? 212 : 176;
        this.f_97727_ = 17 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.f_97731_ = 20 + this.visibleRows * 18;
        this.f_97730_ = 8;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        if (wideTexture) {
            this.f_97730_ += 18;
        }
        if (((BackpackSettingsMenu)this.f_97732_).m_38853_((int)0).f_40221_ >= 0) {
            this.slotYPos = ((BackpackSettingsMenu)this.f_97732_).m_38853_((int)0).f_40221_;
        }
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.f_97726_, this.slotsHeight);
        int slotsXOffset = 7;
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 17, this.slotCount);
        this.renderLockedBackpackSlot(guiGraphics);
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4), true);
        this.m_142416_(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1));
        this.m_142416_(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1), false);
        this.m_142416_(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.m_142416_(this.visibilityWidget);
            if (this.getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().m_36316_().getName())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1));
                this.m_142416_(this.supporterBadgeWidget);
            }
        }
        if (this.isScrollable) {
            int scrollXPos = this.f_97735_ + 7;
            this.scroll = new InventoryScroll(this, Minecraft.m_91087_(), 4, this.visibleRows * 18, this.f_97736_ + 17, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.m_142416_((GuiEventListener)this.scroll);
        }
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.m_6702_().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<GuiEventListener> widgets = this.m_6702_().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    @Override
    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
        }
    }

    @Override
    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 73, 16, 16);
                    } else {
                        guiGraphics.m_280218_(ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 91, 16, 16);
                    }
                    if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                        ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                        guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                    guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.m_6597_(slot, slotId, button, type);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.getSlotUnderMouse();
        if (this.selectSlots(slot, button)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean selectSlots(Slot slot, int button) {
        if (slot != null && slot.f_40219_ >= 0 && slot.f_40219_ < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.add(slot.f_40219_);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.remove((Object)slot.f_40219_);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    if (slot.m_7993_().m_41619_()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)slot.f_40219_, (Object)Pair.of((Object)(this.memoryWidget.matchComponents ? slot.m_7993_() : slot.m_7993_().m_41720_().m_7968_()), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.f_40219_);
                    return true;
                }
            }
        }
        return false;
    }

    public void m_7379_() {
        this.sendDataToServer();
        super.m_7379_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

