/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class ModifierIngredientHelper
implements IIngredientHelper<ModifierEntry> {
    public IIngredientType<ModifierEntry> getIngredientType() {
        return TConstructJEIConstants.MODIFIER_TYPE;
    }

    public String getDisplayName(ModifierEntry entry) {
        return entry.getDisplayName().getString();
    }

    public String getUniqueId(ModifierEntry entry, UidContext context) {
        return entry.getId().toString();
    }

    public ResourceLocation getResourceLocation(ModifierEntry entry) {
        return entry.getId();
    }

    public ModifierEntry copyIngredient(ModifierEntry entry) {
        return entry;
    }

    public String getErrorInfo(@Nullable ModifierEntry entry) {
        if (entry == null) {
            return "null";
        }
        return entry.getId().toString();
    }

    public ItemStack getCheatItemStack(ModifierEntry ingredient) {
        if (!ModifierManager.isInTag(ingredient.getId(), TinkerTags.Modifiers.EXTRACT_MODIFIER_BLACKLIST)) {
            return ModifierCrystalItem.withModifier(ingredient.getId());
        }
        return ItemStack.f_41583_;
    }

    public boolean isValidIngredient(ModifierEntry entry) {
        return entry.isBound();
    }

    public long getAmount(ModifierEntry entry) {
        return entry.getLevel();
    }

    public ModifierEntry copyWithAmount(ModifierEntry entry, long amount) {
        return entry.withLevel((int)amount);
    }

    public ModifierEntry normalizeIngredient(ModifierEntry entry) {
        if (entry.getLevel() == 1) {
            return entry;
        }
        return entry.withLevel(1);
    }

    public Stream<ResourceLocation> getTagStream(ModifierEntry entry) {
        return ModifierManager.getTagKeys(entry.getId()).map(TagKey::f_203868_);
    }

    public boolean isHiddenFromRecipeViewersByTags(ModifierEntry entry) {
        return ModifierManager.isInTag(entry.getId(), TinkerTags.Modifiers.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<ModifierEntry> entries) {
        List<Modifier> values = entries.stream().map(ModifierEntry::getModifier).toList();
        return ModifierManager.getAllTags().filter(entry -> entry.equals(values)).map(Map.Entry::getKey).findFirst();
    }

    public Iterable<Integer> getColors(ModifierEntry ingredient) {
        return List.of(Integer.valueOf(0xFF000000 | ingredient.getModifier().getColor()));
    }
}

