/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.modifiers.adding.OverslimeCraftingTableRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.OverslimeModifierRecipe;

public class OverslimeModifierRecipeBuilder
extends AbstractRecipeBuilder<OverslimeModifierRecipeBuilder> {
    private Ingredient tools = Ingredient.m_204132_(TinkerTags.Items.DURABILITY);
    private final Ingredient ingredient;
    private final int restoreAmount;

    public static OverslimeModifierRecipeBuilder modifier(ItemLike item, int restoreAmount) {
        return OverslimeModifierRecipeBuilder.modifier(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), restoreAmount);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        ItemStack[] stacks = this.ingredient.m_43908_();
        if (stacks.length == 0) {
            throw new IllegalStateException("Empty ingredient not allowed");
        }
        this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)stacks[0].m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == Ingredient.f_43901_) {
            throw new IllegalStateException("Empty ingredient not allowed");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new OverslimeModifierRecipe(id, this.tools, this.ingredient, this.restoreAmount), OverslimeModifierRecipe.LOADER, advancementId));
    }

    public OverslimeModifierRecipeBuilder saveCrafting(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == Ingredient.f_43901_) {
            throw new IllegalStateException("Empty ingredient not allowed");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new OverslimeCraftingTableRecipe(id, this.tools, this.ingredient, this.restoreAmount), OverslimeCraftingTableRecipe.LOADER, advancementId));
        return this;
    }

    private OverslimeModifierRecipeBuilder(Ingredient ingredient, int restoreAmount) {
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    public static OverslimeModifierRecipeBuilder modifier(Ingredient ingredient, int restoreAmount) {
        return new OverslimeModifierRecipeBuilder(ingredient, restoreAmount);
    }

    public OverslimeModifierRecipeBuilder setTools(Ingredient tools) {
        this.tools = tools;
        return this;
    }
}

