/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;

public class ModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<ModifierRecipeBuilder> {
    protected final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();

    protected ModifierRecipeBuilder(ModifierId result) {
        super(result);
    }

    public static ModifierRecipeBuilder modifier(ModifierId modifier) {
        return new ModifierRecipeBuilder(modifier);
    }

    public static ModifierRecipeBuilder modifier(LazyModifier modifier) {
        return ModifierRecipeBuilder.modifier(modifier.getId());
    }

    public ModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public ModifierRecipeBuilder addInput(Ingredient ingredient) {
        return this.addInput(SizedIngredient.of((Ingredient)ingredient));
    }

    public ModifierRecipeBuilder addInput(ItemLike item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (ItemLike[])new ItemLike[]{item}));
    }

    public ModifierRecipeBuilder addInput(ItemLike item) {
        return this.addInput(item, 1);
    }

    public ModifierRecipeBuilder addInput(TagKey<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public ModifierRecipeBuilder addInput(TagKey<Item> tag) {
        return this.addInput(tag, 1);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty() && !this.allowCrystal) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierRecipe(id, this.inputs, this.tools, this.maxToolSize, this.result, ModifierEntry.VALID_LEVEL.range(this.minLevel, this.maxLevel), this.slots, this.allowCrystal, this.checkTraitLevel), ModifierRecipe.LOADER, advancementId));
    }
}

