/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MeltingFuelLookup {
    private static final MeltingFuel EMPTY;
    private static MeltingFuel SOLID;
    private static final List<MeltingFuel> RECIPES;
    private static final Map<Fluid, MeltingFuel> CACHE;
    private static final Function<Fluid, MeltingFuel> LOOKUP;
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER;

    public static void addFuel(MeltingFuel fuel) {
        if (fuel.getRate() == 0) {
            return;
        }
        LISTENER.checkClear();
        if (fuel.getInput() != FluidIngredient.EMPTY) {
            RECIPES.add(fuel);
        } else if (SOLID == EMPTY) {
            SOLID = fuel;
        } else {
            TConstruct.LOG.warn("Multiple fuel recipes for solid fuel. This usually indicates a datapack error and may cause desyncs. Original {}, latest {}", (Object)SOLID.m_6423_(), (Object)fuel.m_6423_());
        }
    }

    public static boolean isFuel(Fluid fluid) {
        return CACHE.computeIfAbsent(fluid, LOOKUP) != EMPTY;
    }

    public static MeltingFuel getSolid() {
        return SOLID;
    }

    @Nullable
    public static MeltingFuel findFuel(Fluid fluid) {
        MeltingFuel recipe = CACHE.computeIfAbsent(fluid, LOOKUP);
        if (recipe == EMPTY) {
            return null;
        }
        return recipe;
    }

    private MeltingFuelLookup() {
    }

    static {
        SOLID = EMPTY = new MeltingFuel(new ResourceLocation("missingno"), (FluidIngredient)FluidIngredient.EMPTY, 0, 0, 0);
        RECIPES = new ArrayList<MeltingFuel>();
        CACHE = new HashMap<Fluid, MeltingFuel>();
        LOOKUP = fluid -> {
            for (MeltingFuel recipe : RECIPES) {
                if (!recipe.matches((Fluid)fluid)) continue;
                return recipe;
            }
            return EMPTY;
        };
        LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
            SOLID = EMPTY;
            RECIPES.clear();
            CACHE.clear();
        });
    }
}

