/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import java.util.BitSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipe
implements ICustomOutputRecipe<IAlloyTank> {
    public static final RecordLoadable<AlloyRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)AlloyIngredient.LOADABLE.list(2).requiredField("inputs", r -> r.inputs), (RecordField)FluidOutput.Loadable.REQUIRED.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.requiredField("temperature", r -> r.temperature), AlloyRecipe::new);
    private final ResourceLocation id;
    private final List<AlloyIngredient> inputs;
    private final FluidOutput output;
    private final int temperature;

    public FluidStack getOutput() {
        return this.output.get();
    }

    private static BitSet makeBitset(IAlloyTank inv) {
        int tanks = inv.getTanks();
        BitSet used = new BitSet(tanks);
        for (int i = 0; i < tanks; ++i) {
            if (!inv.getFluidInTank(i).isEmpty()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(FluidIngredient ingredient, IAlloyTank inv, BitSet used, boolean checkSize) {
        for (int i = 0; i < inv.getTanks(); ++i) {
            if (used.get(i)) continue;
            FluidStack fluid = inv.getFluidInTank(i);
            if (!(checkSize ? ingredient.test(fluid) : ingredient.test(fluid.getFluid()))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public boolean matches(IAlloyTank inv, Level worldIn) {
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (AlloyIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient.fluid, inv, used, false);
            if (index != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canPerform(IAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return false;
        }
        BitSet used = AlloyRecipe.makeBitset(inv);
        int drainAmount = 0;
        for (AlloyIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient.fluid, inv, used, true);
            if (index == -1) {
                return false;
            }
            if (ingredient.catalyst()) continue;
            FluidStack fluid = inv.getFluidInTank(index);
            drainAmount += ingredient.fluid.getAmount(fluid.getFluid());
        }
        return inv.canFit(this.output.get(), drainAmount);
    }

    public void performRecipe(IMutableAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return;
        }
        FluidStack[] drainFluids = new FluidStack[inv.getTanks()];
        int drainAmount = 0;
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (AlloyIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient.fluid, inv, used, true);
            if (index == -1) {
                return;
            }
            if (ingredient.catalyst) continue;
            assert (drainFluids[index] == null);
            FluidStack fluid = inv.getFluidInTank(index);
            int amount = ingredient.fluid.getAmount(fluid.getFluid());
            drainAmount += amount;
            drainFluids[index] = new FluidStack(fluid, amount);
        }
        if (inv.canFit(this.output.get(), drainAmount)) {
            for (int i = 0; i < drainFluids.length; ++i) {
                FluidStack drained;
                FluidStack toDrain = drainFluids[i];
                if (toDrain == null || (drained = inv.drain(i, toDrain)).getAmount() == toDrain.getAmount()) continue;
                TConstruct.LOG.error("Wrong amount of fluid {} drained for recipe {}", (Object)drained.getFluid(), (Object)this.id);
            }
            int filled = inv.fill(this.output.copy());
            if (filled != this.output.getAmount()) {
                TConstruct.LOG.error("Filled only {} for recipe {}", (Object)filled, (Object)this.id);
            }
        }
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.ALLOYING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.alloyingSerializer.get();
    }

    public AlloyRecipe(ResourceLocation id, List<AlloyIngredient> inputs, FluidOutput output, int temperature) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.temperature = temperature;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public List<AlloyIngredient> getInputs() {
        return this.inputs;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public record AlloyIngredient(FluidIngredient fluid, boolean catalyst) {
        public static final RecordLoadable<AlloyIngredient> LOADABLE = RecordLoadable.create((RecordField)FluidIngredient.LOADABLE.tryDirectField("match", AlloyIngredient::fluid, new String[0]), (RecordField)BooleanLoadable.INSTANCE.defaultField("catalyst", (Object)false, false, AlloyIngredient::catalyst), AlloyIngredient::new).compact(FluidIngredient.LOADABLE.flatXmap(fluid -> new AlloyIngredient((FluidIngredient)fluid, false), AlloyIngredient::fluid), alloy -> !alloy.catalyst());
    }
}

