/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.timeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiTimelineKey<T>
extends GuiControl
implements Comparable<GuiTimelineKey> {
    public static final double DRAG_TIME = 2.0;
    public GuiTimelineChannel channel;
    public boolean modifiable = true;
    public int tick;
    public T value;
    private boolean selected;
    private boolean clicked;

    public GuiTimelineKey(GuiTimelineChannel channel, int tick, T value) {
        super("");
        this.channel = channel;
        this.tick = tick;
        this.value = value;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0) {
            this.channel.select(this);
            GuiTimelineKey.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
            this.clicked = true;
        } else if (button == 1) {
            if (this.selected) {
                this.channel.timeline.deselect();
            }
            this.channel.removeKey(this);
            GuiTimelineKey.playSound(SoundEvents.f_12016_, 0.1f, 0.6f);
        }
        return true;
    }

    @Override
    public void mouseDragged(Rect rect, double x, double y, int button, double dragX, double dragY, double time) {
        if (this.clicked && time > 2.0) {
            this.channel.dragKey(this);
            this.clicked = false;
        }
        super.mouseDragged(rect, x, y, button, dragX, dragY, time);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        this.clicked = false;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void removeKey() {
        this.channel.removeKey(this);
    }

    @Override
    public int compareTo(GuiTimelineKey o) {
        return Integer.compare(this.tick, o.tick);
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 6;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 6;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    public Rect createChildRect(GuiChildControl child, Rect contentRect, double scale, double xOffset, double yOffset) {
        Rect temp = child.rect.copy();
        temp.grow(Math.max(temp.getWidth() / 4.0, temp.getHeight() / 4.0));
        return contentRect.child(temp, scale, xOffset, yOffset);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, GuiChildControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        PoseStack pose = graphics.m_280168_();
        GuiStyle style = this.getStyle();
        pose.m_85836_();
        double width = control.getWidth();
        double height = control.getHeight();
        pose.m_85837_(width * 0.5, height * 0.5, 0.0);
        pose.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        pose.m_85837_(width * -0.5, height * -0.5, 0.0);
        int borderWidth = style.getBorder(ControlFormatting.ControlStyleBorder.SMALL);
        style.border.render(pose, width, height);
        StyleDisplay foreground = style.clickable;
        if (!this.enabled || !this.modifiable) {
            foreground = style.disabledBackground;
        } else if (this.selected) {
            foreground = style.headerBackground;
        } else if (controlRect.inside(mouseX, mouseY)) {
            foreground = style.clickableHighlight;
        }
        foreground.render(pose, borderWidth, borderWidth, width - (double)(borderWidth * 2), height - (double)(borderWidth * 2));
        pose.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
    }
}

