/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
implements RecipeSerializer<T> {
    private final ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory;

    public ProcessingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory) {
        this.factory = factory;
    }

    protected void writeToJson(JsonObject json, T recipe) {
        HeatCondition requiredHeat;
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        ((ProcessingRecipe)recipe).ingredients.forEach(i -> jsonIngredients.add(i.m_43942_()));
        ((ProcessingRecipe)recipe).fluidIngredients.forEach(i -> jsonIngredients.add((JsonElement)i.serialize()));
        ((ProcessingRecipe)recipe).results.forEach(o -> jsonOutputs.add(o.serialize()));
        ((ProcessingRecipe)recipe).fluidResults.forEach(o -> jsonOutputs.add(FluidHelper.serializeFluidStack(o)));
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("results", (JsonElement)jsonOutputs);
        int processingDuration = ((ProcessingRecipe)recipe).getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        if ((requiredHeat = ((ProcessingRecipe)recipe).getRequiredHeat()) != HeatCondition.NONE) {
            json.addProperty("heatRequirement", requiredHeat.serialize());
        }
        ((ProcessingRecipe)recipe).writeAdditional(json);
    }

    protected T readFromJson(ResourceLocation recipeId, JsonObject json) {
        ProcessingRecipeBuilder<T> builder = new ProcessingRecipeBuilder<T>(this.factory, recipeId);
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList fluidIngredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
            if (FluidIngredient.isFluidIngredient(je)) {
                fluidIngredients.add((Object)FluidIngredient.deserialize(je));
                continue;
            }
            ingredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            if (GsonHelper.m_13900_((JsonObject)jsonObject, (String)"fluid")) {
                fluidResults.add((Object)FluidHelper.deserializeFluidStack(jsonObject));
                continue;
            }
            results.add((Object)ProcessingOutput.deserialize(je));
        }
        builder.withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"processingTime")) {
            builder.duration(GsonHelper.m_13927_((JsonObject)json, (String)"processingTime"));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"heatRequirement")) {
            builder.requiresHeat(HeatCondition.deserialize(GsonHelper.m_13906_((JsonObject)json, (String)"heatRequirement")));
        }
        T recipe = builder.build();
        ((ProcessingRecipe)recipe).readAdditional(json);
        return recipe;
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, T recipe) {
        NonNullList<Ingredient> ingredients = ((ProcessingRecipe)recipe).ingredients;
        NonNullList<FluidIngredient> fluidIngredients = ((ProcessingRecipe)recipe).fluidIngredients;
        NonNullList<ProcessingOutput> outputs = ((ProcessingRecipe)recipe).results;
        NonNullList<FluidStack> fluidOutputs = ((ProcessingRecipe)recipe).fluidResults;
        buffer.m_130130_(ingredients.size());
        ingredients.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(fluidIngredients.size());
        fluidIngredients.forEach(i -> i.write(buffer));
        buffer.m_130130_(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.m_130130_(fluidOutputs.size());
        fluidOutputs.forEach(o -> o.writeToPacket(buffer));
        buffer.m_130130_(((ProcessingRecipe)recipe).getProcessingDuration());
        buffer.m_130130_(((ProcessingRecipe)recipe).getRequiredHeat().ordinal());
        ((ProcessingRecipe)recipe).writeAdditional(buffer);
    }

    protected T readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList fluidIngredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidIngredients.add((Object)FluidIngredient.read(buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read(buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidResults.add((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
        T recipe = new ProcessingRecipeBuilder<T>(this.factory, recipeId).withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults).duration(buffer.m_130242_()).requiresHeat(HeatCondition.values()[buffer.m_130242_()]).build();
        ((ProcessingRecipe)recipe).readAdditional(buffer);
        return recipe;
    }

    public final void write(JsonObject json, T recipe) {
        this.writeToJson(json, recipe);
    }

    public final T fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(FriendlyByteBuf buffer, T recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        return this.readFromBuffer(id, buffer);
    }

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> getFactory() {
        return this.factory;
    }
}

