/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactScreen;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ElevatorContactBlock
extends WrenchableDirectionalBlock
implements IBE<ElevatorContactBlockEntity>,
SpecialBlockItemRequirement {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty CALLING = BooleanProperty.m_61465_((String)"calling");
    public static final BooleanProperty POWERING = BrassDiodeBlock.POWERING;

    public ElevatorContactBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CALLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52588_, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{CALLING, POWERING, POWERED}));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched != InteractionResult.SUCCESS) {
            return onWrenched;
        }
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return onWrenched;
        }
        BlockPos pos = context.m_8083_();
        state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)RedstoneContactBlock.f_52588_);
        if (facing.m_122434_() != Direction.Axis.Y && ElevatorColumn.get((LevelAccessor)level, new ElevatorColumn.ColumnCoords(pos.m_123341_(), pos.m_123343_(), facing)) != null) {
            return onWrenched;
        }
        level.m_46597_(pos, BlockHelper.copyProperties(state, AllBlocks.REDSTONE_CONTACT.getDefaultState()));
        return onWrenched;
    }

    @Nullable
    public static ElevatorColumn.ColumnCoords getColumnCoords(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (!AllBlocks.ELEVATOR_CONTACT.has(blockState) && !AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            return null;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_52588_);
        BlockPos target = pos;
        return new ElevatorColumn.ColumnCoords(target.m_123341_(), target.m_123343_(), facing);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean isPowered = (Boolean)pState.m_61143_((Property)POWERED);
        if (isPowered == pLevel.m_276867_(pPos)) {
            return;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        if (isPowered) {
            return;
        }
        if (((Boolean)pState.m_61143_((Property)CALLING)).booleanValue()) {
            return;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.getOrCreate((LevelAccessor)pLevel, ElevatorContactBlock.getColumnCoords((LevelAccessor)pLevel, pPos));
        this.callToContactAndUpdate(elevatorColumn, pState, pLevel, pPos, true);
    }

    public void callToContactAndUpdate(ElevatorColumn elevatorColumn, BlockState pState, Level pLevel, BlockPos pPos, boolean powered) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)CALLING), 2);
        for (BlockPos otherPos : elevatorColumn.getContacts()) {
            BlockState otherState;
            if (otherPos.equals((Object)pPos) || !AllBlocks.ELEVATOR_CONTACT.has(otherState = pLevel.m_8055_(otherPos))) continue;
            pLevel.m_7731_(otherPos, (BlockState)otherState.m_61124_((Property)CALLING, (Comparable)Boolean.valueOf(false)), 18);
            this.scheduleActivation((LevelAccessor)pLevel, otherPos);
        }
        if (powered) {
            pState = (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)CALLING, (Comparable)Boolean.valueOf(true)), 2);
        pLevel.m_46672_(pPos, (Block)this);
        elevatorColumn.target(pPos.m_123342_());
        elevatorColumn.markDirty();
    }

    public void scheduleActivation(LevelAccessor pLevel, BlockPos pPos) {
        if (!pLevel.m_183326_().m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        boolean wasPowering = (Boolean)pState.m_61143_((Property)POWERING);
        Optional optionalBE = this.getBlockEntityOptional((BlockGetter)pLevel, pPos);
        boolean shouldBePowering = optionalBE.map(be -> {
            boolean activateBlock = be.activateBlock;
            be.activateBlock = false;
            be.m_6596_();
            return activateBlock;
        }).orElse(false);
        if (wasPowering || (shouldBePowering |= RedstoneContactBlock.hasValidContact((LevelAccessor)pLevel, pPos, (Direction)pState.m_61143_((Property)f_52588_)))) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(shouldBePowering)), 18);
        }
        pLevel.m_46672_(pPos, (Block)this);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != stateIn.m_61143_((Property)f_52588_)) {
            return stateIn;
        }
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(worldIn, currentPos, facing);
        if ((Boolean)stateIn.m_61143_((Property)POWERING) != hasValidContact) {
            this.scheduleActivation(worldIn, currentPos);
        }
        return stateIn;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERING);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return AllBlocks.REDSTONE_CONTACT.asStack();
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (side == null) {
            return true;
        }
        return state.m_61143_((Property)f_52588_) != side.m_122424_();
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side == null) {
            return 0;
        }
        BlockState toState = blockAccess.m_8055_(pos.m_121945_(side.m_122424_()));
        if (toState.m_60713_((Block)this)) {
            return 0;
        }
        return (Boolean)state.m_61143_((Property)POWERING) != false ? 15 : 0;
    }

    @Override
    public Class<ElevatorContactBlockEntity> getBlockEntityClass() {
        return ElevatorContactBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ElevatorContactBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.ELEVATOR_CONTACT.get();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return ItemRequirement.of(AllBlocks.REDSTONE_CONTACT.getDefaultState(), be);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && AllItems.WRENCH.isIn(player.m_21120_(handIn))) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> this.displayScreen((ElevatorContactBlockEntity)be, player)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(ElevatorContactBlockEntity be, Player player) {
        if (player instanceof LocalPlayer) {
            ScreenOpener.open((Screen)new ElevatorContactScreen(be.m_58899_(), be.shortName, be.longName, be.doorControls.mode));
        }
    }

    public static int getLight(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERING) != false ? 10 : 0;
    }
}

