/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.EmptyResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class ConditionedResourceSelector {
    public static final Codec<ConditionedResourceSelector> DIRECT_CODEC = ExtraCodecs.f_252400_.flatXmap(element -> {
        try {
            return DataResult.success((Object)ConditionedResourceSelector.deserialize("selector", element));
        }
        catch (JsonParseException exception) {
            String message = exception.getMessage();
            return DataResult.error(() -> message);
        }
    }, selector -> {
        try {
            return DataResult.success((Object)selector.serialize());
        }
        catch (JsonParseException exception) {
            String message = exception.getMessage();
            return DataResult.error(() -> message);
        }
    });
    public static final Codec<ConditionedResourceSelector> CODEC = DIRECT_CODEC.fieldOf("selector").codec();
    public static final ConditionedResourceSelector EMPTY = new ConditionedResourceSelector(EmptyResourceSelector.INSTANCE);
    private static final ICondition[] NO_CONDITIONS = new ICondition[0];
    private final ResourceSelector<?> resourceSelector;
    private final ICondition[] conditions;

    public ConditionedResourceSelector(ResourceSelector<?> resourceSelector, ICondition ... conditions) {
        this.resourceSelector = resourceSelector;
        this.conditions = conditions;
    }

    public ConditionedResourceSelector(ResourceSelector<?> resourceSelector) {
        this(resourceSelector, NO_CONDITIONS);
    }

    public static ConditionedResourceSelector deserialize(String key, JsonElement element) throws JsonParseException {
        JsonPrimitive primitive;
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            return new ConditionedResourceSelector(new NamesResourceSelector(new ResourceLocation(primitive.getAsString())));
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)"conditions") || CraftingHelper.processConditions((JsonArray)GsonHelper.m_13933_((JsonObject)jsonObject, (String)"conditions"), (ICondition.IContext)ICondition.IContext.EMPTY)) {
                String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
                ResourceSelector.Serializer<?> serializer = ResourceSelectorSerializers.INSTANCE.getSerializer(type);
                if (serializer != null) {
                    return new ConditionedResourceSelector((ResourceSelector<?>)serializer.deserialize(jsonObject.get("config")));
                }
                throw new JsonParseException("Unknown selector type: " + type);
            }
            return EMPTY;
        }
        if (element == null) {
            throw new JsonParseException("Missing '" + key + "' member!");
        }
        throw new JsonParseException("'" + key + "' must be a string or object!");
    }

    public JsonElement serialize() {
        NamesResourceSelector namesResourceSelector;
        Set<ResourceLocation> names;
        ICondition[] conditions = this.conditions;
        boolean hasConditions = conditions != null && conditions.length > 0;
        ResourceSelector<?> selector = this.resourceSelector;
        if (!hasConditions && selector instanceof NamesResourceSelector && (names = (namesResourceSelector = (NamesResourceSelector)selector).names()).size() == 1) {
            return new JsonPrimitive(names.iterator().next().toString());
        }
        ResourceSelector.Serializer<?> serializer = selector.getSerializer();
        String type = ResourceSelectorSerializers.INSTANCE.getSerializerID(serializer);
        if (type == null) {
            throw new JsonParseException("Could not find name for selector serializer: " + serializer);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(type));
        jsonObject.add("config", selector.serialize());
        if (hasConditions) {
            JsonArray conditionsArray = new JsonArray();
            for (ICondition condition : conditions) {
                conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            jsonObject.add("conditions", (JsonElement)conditionsArray);
        }
        return jsonObject;
    }

    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        return this.resourceSelector.select();
    }

    public ResourceSelector<?> getResourceSelector() {
        return this.resourceSelector;
    }

    public ICondition[] getConditions() {
        return this.conditions;
    }
}

