/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Set;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public final class ServerEntityMixin {
    @Shadow
    @Final
    private Entity f_8510_;

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;hasImpulse:Z", ordinal=2, shift=At.Shift.AFTER)}, method={"sendChanges"})
    private void sendImpulse(CallbackInfo info) {
        ServerEntityMixin.updateEntityData(this.f_8510_);
    }

    @Inject(at={@At(value="HEAD")}, method={"sendChanges"})
    private void sendChanges(CallbackInfo info) {
        Entity entity = this.f_8510_;
        IDataManager dataManager = (IDataManager)entity;
        if (dataManager.isDirty()) {
            ServerEntityMixin.updateEntityData(entity);
        }
    }

    private static void updateEntityData(Entity entity) {
        IDataManager dataManager = (IDataManager)entity;
        Set<IDataManager.DataEntry<?>> entries = dataManager.getDirtyEntries();
        if (!entries.isEmpty()) {
            if (entity instanceof ServerPlayer) {
                NetworkUtil.updateTrackedData((ServerPlayer)entity, entity.m_19879_(), entries);
            }
            NetworkUtil.updateTrackedData(entity, entries);
        }
        dataManager.clean();
    }
}

