/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.vector;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorVectorRaycastAxis
extends PieceOperator {
    SpellParam<Vector3> origin;
    SpellParam<Vector3> ray;
    SpellParam<Number> max;

    public PieceOperatorVectorRaycastAxis(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", SpellParam.GREEN, false, false);
        this.addParam(this.ray);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.PURPLE, true, false);
        this.addParam(this.max);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 originVal = this.getParamValue(context, this.origin);
        Vector3 rayVal = this.getParamValue(context, this.ray);
        if (originVal == null || rayVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        double maxLen = SpellHelpers.rangeLimitParam(this, context, this.max, 32.0);
        Vector3 end = originVal.copy().add(rayVal.copy().normalize().multiply(maxLen));
        BlockHitResult pos = context.caster.m_20193_().m_45547_(new ClipContext(originVal.toVec3D(), end.toVec3D(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)context.caster));
        if (pos.m_6662_() == HitResult.Type.MISS) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        Direction facing = pos.m_82434_();
        return new Vector3(facing.m_122429_(), facing.m_122430_(), facing.m_122431_());
    }

    @Override
    public Class<?> getEvaluationType() {
        return Vector3.class;
    }
}

