/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;

public class SafeChunkBounds {
    public static final SafeChunkBounds ANY = new SafeChunkBounds(){

        @Override
        public boolean inBounds(BlockPos pos, boolean gap) {
            return true;
        }
    };
    public static final SafeChunkBounds ANY_WG = new SafeChunkBounds(){

        @Override
        public boolean inBounds(BlockPos pos, boolean gap) {
            return true;
        }
    };
    protected static final Tile[] TILES = new Tile[16];
    private final ChunkPos center;
    private final BlockBounds[] chunkBounds = new BlockBounds[16];

    protected SafeChunkBounds() {
        this.center = null;
    }

    public SafeChunkBounds(WorldGenLevel world, ChunkPos pos) {
        this.center = pos;
        for (Tile tile : TILES) {
            ChunkPos cp = new ChunkPos(pos.f_45578_ + tile.pos.f_45578_, pos.f_45579_ + tile.pos.f_45579_);
            boolean loaded = world.m_7726_().m_7587_(cp.f_45578_, cp.f_45579_, ChunkStatus.f_62314_, false) != null;
            this.chunkBounds[tile.index] = loaded ? new BlockBounds((LevelAccessor)world, cp) : BlockBounds.INVALID;
        }
        for (Tile tile : TILES) {
            BlockBounds curr = this.chunkBounds[tile.index];
            if (curr == BlockBounds.INVALID) continue;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                boolean validDir = false;
                if ((tile.borders & 1 << dir.m_122411_()) != 0) {
                    BlockBounds adjTile = this.chunkBounds[tile.index + dir.m_122429_() + dir.m_122431_() * 4];
                    boolean bl = validDir = adjTile != BlockBounds.INVALID;
                }
                if (validDir) continue;
                curr.shrink(dir, 1);
            }
        }
    }

    public boolean inBounds(BlockPos pos, boolean gap) {
        int chunkZ;
        int tileZ;
        int chunkX = pos.m_123341_() >> 4;
        int tileX = chunkX - this.center.f_45578_ + 1;
        if (((tileX | (tileZ = (chunkZ = pos.m_123343_() >> 4) - this.center.f_45579_ + 1)) & 0xFFFFFFFC) == 0) {
            int index = tileX + tileZ * 4;
            return !gap && this.chunkBounds[index] != BlockBounds.INVALID || this.chunkBounds[index].inBounds(pos);
        }
        return false;
    }

    public boolean inBounds(BlockBounds bounds, boolean gap) {
        BlockPos min = bounds.getMin();
        BlockPos max = bounds.getMax();
        return this.inBounds(min, gap) && this.inBounds(max, gap) && this.inBounds(new BlockPos(min.m_123341_(), 0, max.m_123343_()), gap) && this.inBounds(new BlockPos(max.m_123341_(), 0, min.m_123343_()), gap);
    }

    public void setBlockState(LevelAccessor world, BlockPos pos, BlockState state, boolean gap) {
        this.setBlockState(world, pos, state, 3, gap);
    }

    public void setBlockState(LevelAccessor world, BlockPos pos, BlockState state, int flags, boolean gap) {
        if (this.inBounds(pos, gap)) {
            world.m_7731_(pos, state, flags);
        }
    }

    static {
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 4; ++x) {
                int index = z * 4 + x;
                SafeChunkBounds.TILES[index] = new Tile(index, new ChunkPos(x - 1, z - 1), (z != 0 ? 4 : 0) | (z != 3 ? 8 : 0) | (x != 0 ? 16 : 0) | (x != 3 ? 32 : 0));
            }
        }
    }

    protected static class Tile {
        public final ChunkPos pos;
        public final int borders;
        public final int index;

        public Tile(int index, ChunkPos pos, int borderFlags) {
            this.index = index;
            this.pos = pos;
            this.borders = borderFlags;
        }
    }
}

