/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchConnectionData;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BranchDestructionData {
    public final Species species;
    public final int[] destroyedBranchesRadiusPosition;
    public final int[] destroyedBranchesConnections;
    public final int[] destroyedBranchesBlockIndex;
    public final int[] destroyedLeaves;
    public final int[] destroyedLeavesBlockIndex;
    public final List<BranchBlock.ItemStackPos> leavesDrops;
    public final int[] endPoints;
    public final NetVolumeNode.Volume woodVolume;
    public final Direction cutDir;
    public final Direction toolDir;
    public final BlockPos cutPos;
    public final BlockPos basePos;
    public final int trunkHeight;
    public static final BlockBounds bounds = new BlockBounds(new BlockPos(-64, -64, -64), new BlockPos(64, 64, 64));
    private Map<BlockPos, BranchConnectionData> unencodedBranches;
    private Map<BlockPos, BlockState> unencodedLeaves;
    private List<BlockPos> unencodedEnds;

    public BranchDestructionData() {
        this.species = Species.NULL_SPECIES;
        this.destroyedBranchesConnections = new int[0];
        this.destroyedBranchesRadiusPosition = new int[0];
        this.destroyedBranchesBlockIndex = new int[0];
        this.destroyedLeaves = new int[0];
        this.destroyedLeavesBlockIndex = new int[0];
        this.leavesDrops = new ArrayList<BranchBlock.ItemStackPos>(0);
        this.endPoints = new int[0];
        this.woodVolume = new NetVolumeNode.Volume();
        this.cutDir = Direction.DOWN;
        this.toolDir = Direction.DOWN;
        this.cutPos = BlockPos.f_121853_;
        this.basePos = BlockPos.f_121853_;
        this.trunkHeight = 0;
    }

    public BranchDestructionData(Species species, Map<BlockPos, BranchConnectionData> branches, Map<BlockPos, BlockState> leaves, List<BranchBlock.ItemStackPos> leavesDrops, List<BlockPos> ends, NetVolumeNode.Volume volume, BlockPos cutPos, BlockPos basePos, Direction cutDir, Direction toolDir, int trunkHeight) {
        this.species = species;
        int[][] encodedBranchData = this.convertBranchesToIntArrays(branches);
        this.destroyedBranchesRadiusPosition = encodedBranchData[0];
        this.destroyedBranchesConnections = encodedBranchData[1];
        this.destroyedBranchesBlockIndex = encodedBranchData[2];
        int[][] encodedLeavesData = this.convertLeavesToIntArray(leaves, species);
        this.destroyedLeaves = encodedLeavesData[0];
        this.destroyedLeavesBlockIndex = encodedLeavesData[1];
        this.leavesDrops = leavesDrops;
        this.endPoints = this.convertEndPointsToIntArray(ends);
        this.woodVolume = volume;
        this.cutPos = cutPos;
        this.basePos = basePos;
        this.cutDir = cutDir;
        this.toolDir = toolDir;
        this.trunkHeight = trunkHeight;
        this.unencodedBranches = branches;
        this.unencodedLeaves = leaves;
        this.unencodedEnds = ends;
    }

    public BranchDestructionData(Species species, Map<BlockPos, BranchConnectionData> branches, Map<BlockPos, BlockState> leaves, List<BranchBlock.ItemStackPos> leavesDrops, List<BlockPos> ends, NetVolumeNode.Volume volume, BlockPos cutPos, Direction cutDir, Direction toolDir, int trunkHeight) {
        this(species, branches, leaves, leavesDrops, ends, volume, cutPos, cutPos, cutDir, toolDir, trunkHeight);
    }

    public BranchDestructionData merge(BranchDestructionData other) {
        BlockPos offset = other.cutPos.m_121996_((Vec3i)this.cutPos);
        HashMap<BlockPos, BranchConnectionData> newBranches = new HashMap<BlockPos, BranchConnectionData>(this.unencodedBranches);
        other.unencodedBranches.forEach((key, value) -> newBranches.put(key.m_121955_((Vec3i)offset), (BranchConnectionData)value));
        HashMap<BlockPos, BlockState> newLeaves = new HashMap<BlockPos, BlockState>(this.unencodedLeaves);
        other.unencodedLeaves.forEach((key, value) -> newLeaves.put(key.m_121955_((Vec3i)offset), (BlockState)value));
        LinkedList<BranchBlock.ItemStackPos> newLeavesDrops = new LinkedList<BranchBlock.ItemStackPos>(this.leavesDrops);
        newLeavesDrops.addAll(other.leavesDrops.stream().map(a -> new BranchBlock.ItemStackPos(a.stack, a.pos.m_121955_((Vec3i)offset))).toList());
        LinkedList<BlockPos> newEnds = new LinkedList<BlockPos>(this.unencodedEnds);
        newEnds.addAll(other.unencodedEnds.stream().map(e -> e.m_121955_((Vec3i)offset)).toList());
        NetVolumeNode.Volume newVolume = new NetVolumeNode.Volume(this.woodVolume.getRawVolumesArray());
        newVolume.addVolume(other.woodVolume);
        BlockPos newBasePos = this.basePos.m_123342_() < other.basePos.m_123342_() ? this.basePos : other.basePos;
        int maxY = Math.max(this.basePos.m_123342_() + this.trunkHeight, other.basePos.m_123342_() + other.trunkHeight);
        int newHeight = maxY - newBasePos.m_123342_();
        return new BranchDestructionData(this.species, newBranches, newLeaves, newLeavesDrops, newEnds, newVolume, this.cutPos, newBasePos, this.cutDir, this.toolDir, newHeight);
    }

    public BranchDestructionData(CompoundTag nbt) {
        this.species = TreeRegistry.findSpecies(new ResourceLocation(nbt.m_128461_("species")));
        this.destroyedBranchesRadiusPosition = nbt.m_128465_("branchpos");
        this.destroyedBranchesConnections = nbt.m_128465_("branchcon");
        this.destroyedBranchesBlockIndex = nbt.m_128465_("branchblock");
        this.destroyedLeaves = nbt.m_128465_("leavespos");
        this.destroyedLeavesBlockIndex = nbt.m_128465_("leavesblock");
        this.leavesDrops = new ArrayList<BranchBlock.ItemStackPos>();
        this.endPoints = nbt.m_128465_("ends");
        this.woodVolume = new NetVolumeNode.Volume(nbt.m_128465_("volume"));
        this.cutPos = new BlockPos(nbt.m_128451_("cutx"), nbt.m_128451_("cuty"), nbt.m_128451_("cutz"));
        this.basePos = new BlockPos(nbt.m_128451_("basex"), nbt.m_128451_("basey"), nbt.m_128451_("basez"));
        this.cutDir = Direction.values()[Mth.m_14045_((int)nbt.m_128451_("cutdir"), (int)0, (int)(Direction.values().length - 1))];
        this.toolDir = Direction.values()[Mth.m_14045_((int)nbt.m_128451_("tooldir"), (int)0, (int)(Direction.values().length - 1))];
        this.trunkHeight = nbt.m_128451_("trunkheight");
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128359_("species", this.species.getRegistryName().toString());
        tag.m_128385_("branchpos", this.destroyedBranchesRadiusPosition);
        tag.m_128385_("branchcon", this.destroyedBranchesConnections);
        tag.m_128385_("branchblock", this.destroyedBranchesBlockIndex);
        tag.m_128385_("leavespos", this.destroyedLeaves);
        tag.m_128385_("leavesblock", this.destroyedLeavesBlockIndex);
        tag.m_128385_("ends", this.endPoints);
        tag.m_128385_("volume", this.woodVolume.getRawVolumesArray());
        tag.m_128405_("cutx", this.cutPos.m_123341_());
        tag.m_128405_("cuty", this.cutPos.m_123342_());
        tag.m_128405_("cutz", this.cutPos.m_123343_());
        tag.m_128405_("basex", this.basePos.m_123341_());
        tag.m_128405_("basey", this.basePos.m_123342_());
        tag.m_128405_("basez", this.basePos.m_123343_());
        tag.m_128405_("cutdir", this.cutDir.m_122411_());
        tag.m_128405_("tooldir", this.toolDir.m_122411_());
        tag.m_128405_("trunkheight", this.trunkHeight);
        return tag;
    }

    private int[][] convertBranchesToIntArrays(Map<BlockPos, BranchConnectionData> branchList) {
        int[] radPosData = new int[branchList.size()];
        int[] connectionData = new int[branchList.size()];
        int[] blockIndexData = new int[branchList.size()];
        int index = 0;
        BranchConnectionData origConnData = branchList.get(BlockPos.f_121853_);
        if (origConnData != null) {
            BlockState origState = origConnData.getBlockState();
            radPosData[index] = this.encodeBranchesRadiusPos(BlockPos.f_121853_, (BranchBlock)origState.m_60734_(), origState);
            connectionData[index] = this.encodeBranchesConnections(origConnData.getConnections());
            blockIndexData[index++] = this.encodeBranchBlocks((BranchBlock)origState.m_60734_());
        }
        for (Map.Entry<BlockPos, BranchConnectionData> set : branchList.entrySet()) {
            if (set.getKey().equals((Object)BlockPos.f_121853_)) continue;
            BlockPos relPos = set.getKey();
            BranchConnectionData connData = set.getValue();
            BlockState state = connData.getBlockState();
            Block block = state.m_60734_();
            if (!(block instanceof BranchBlock) || !bounds.inBounds(relPos)) continue;
            radPosData[index] = this.encodeBranchesRadiusPos(relPos, (BranchBlock)block, state);
            connectionData[index] = this.encodeBranchesConnections(connData.getConnections());
            blockIndexData[index++] = this.encodeBranchBlocks((BranchBlock)block);
        }
        radPosData = Arrays.copyOf(radPosData, index);
        connectionData = Arrays.copyOf(connectionData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{radPosData, connectionData, blockIndexData};
    }

    private int encodeBranchesRadiusPos(BlockPos relPos, BranchBlock branchBlock, BlockState state) {
        return (branchBlock.getRadius(state) & 0x1F) << 24 | BranchDestructionData.encodeRelBlockPos(relPos);
    }

    private int encodeBranchesConnections(Connections exState) {
        int result = 0;
        int[] radii = exState.getAllRadii();
        for (Direction face : Direction.values()) {
            int faceIndex = face.m_122411_();
            int rad = radii[faceIndex];
            result |= (rad & 0x1F) << faceIndex * 5;
        }
        return result;
    }

    private int encodeBranchBlocks(BranchBlock branch) {
        return branch.getFamily().getBranchBlockIndex(branch);
    }

    public int getNumBranches() {
        return this.destroyedBranchesRadiusPosition.length;
    }

    public BlockPos getBranchRelPos(int index) {
        BlockPos pos = BranchDestructionData.decodeRelPos(this.destroyedBranchesRadiusPosition[index]);
        if (this.basePos != this.cutPos) {
            return pos.m_121955_((Vec3i)this.getRelativeCutPos());
        }
        return pos;
    }

    public BlockPos getRelativeCutPos() {
        return this.cutPos.m_121996_((Vec3i)this.basePos);
    }

    public int getBranchRadius(int index) {
        return this.decodeBranchRadius(this.destroyedBranchesRadiusPosition[index]);
    }

    private int decodeBranchRadius(int encoded) {
        return encoded >> 24 & 0x1F;
    }

    @Nullable
    public BlockState getBranchBlockState(int index) {
        BranchBlock branch;
        if (this.destroyedBranchesBlockIndex.length > 0 && (branch = this.species.getFamily().getValidBranchBlock(this.destroyedBranchesBlockIndex[index])) != null) {
            int radius = this.decodeBranchRadius(this.destroyedBranchesRadiusPosition[index]);
            return branch.getStateForRadius(radius);
        }
        return null;
    }

    public void getConnections(int index, int[] connections) {
        int encodedConnections = this.destroyedBranchesConnections[index];
        for (Direction face : Direction.values()) {
            int rad = encodedConnections >> face.m_122411_() * 5 & 0x1F;
            connections[face.m_122411_()] = Math.max(0, rad);
        }
    }

    private int[][] convertLeavesToIntArray(Map<BlockPos, BlockState> leavesList, Species species) {
        int[] posData = new int[leavesList.size()];
        int[] blockIndexData = new int[leavesList.size()];
        int index = 0;
        for (Map.Entry<BlockPos, BlockState> set : leavesList.entrySet()) {
            Block block;
            BlockState state;
            BlockPos relPos = set.getKey();
            if (!species.canEncodeLeavesBlocks(relPos, state = set.getValue(), block = state.m_60734_(), this) || !bounds.inBounds(relPos)) continue;
            posData[index] = species.encodeLeavesPos(relPos, state, block, this);
            blockIndexData[index++] = species.encodeLeavesBlocks(relPos, state, block, this);
        }
        posData = Arrays.copyOf(posData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{posData, blockIndexData};
    }

    public int getNumLeaves() {
        return this.destroyedLeaves.length;
    }

    public BlockPos getLeavesRelPos(int index) {
        BlockPos pos = this.decodeLeavesRelPos(this.destroyedLeaves[index]);
        if (this.basePos != this.cutPos) {
            return pos.m_121955_((Vec3i)this.getRelativeCutPos());
        }
        return pos;
    }

    private BlockPos decodeLeavesRelPos(int encoded) {
        return BranchDestructionData.decodeRelPos(encoded);
    }

    public int getLeavesHydro(int index) {
        return this.decodeLeavesHydro(this.destroyedLeaves[index]);
    }

    private int decodeLeavesHydro(int encoded) {
        return encoded >> 24 & 0xF;
    }

    public LeavesProperties getLeavesProperties(int index) {
        return this.species.getValidLeavesProperties(this.destroyedLeavesBlockIndex[index]);
    }

    @Nullable
    public BlockState getLeavesBlockState(int index) {
        DynamicLeavesBlock leaves = this.species.getValidLeafBlock(this.destroyedLeavesBlockIndex[index]);
        if (leaves != null) {
            return leaves.m_49966_();
        }
        return null;
    }

    private int[] convertEndPointsToIntArray(List<BlockPos> endPoints) {
        int[] data = new int[endPoints.size()];
        int index = 0;
        for (BlockPos relPos : endPoints) {
            if (!bounds.inBounds(relPos)) continue;
            data[index++] = BranchDestructionData.encodeRelBlockPos(relPos);
        }
        return Arrays.copyOf(data, index);
    }

    public int getNumEndpoints() {
        return this.endPoints.length;
    }

    public BlockPos getEndPointRelPos(int index) {
        BlockPos pos = BranchDestructionData.decodeRelPos(this.endPoints[index]);
        if (this.basePos != this.cutPos) {
            return pos.m_121955_((Vec3i)this.getRelativeCutPos());
        }
        return pos;
    }

    public Iterable<BlockPos> getPositions(PosType posType) {
        return this.getPositions(posType, true);
    }

    public Iterable<BlockPos> getPositions(PosType posType, boolean absolute) {
        Function<Integer, BlockPos> getter;
        return new Iterable<BlockPos>(){
            final /* synthetic */ int val$limit;
            final /* synthetic */ Function val$getter;
            {
                this.val$limit = n;
                this.val$getter = function;
            }

            @Override
            @Nonnull
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int index = 0;

                    protected BlockPos computeNext() {
                        return this.index < val$limit ? (BlockPos)val$getter.apply(this.index++) : (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    public static int encodeRelBlockPos(BlockPos relPos) {
        return (relPos.m_123341_() + 64 & 0xFF) << 16 | (relPos.m_123342_() + 64 & 0xFF) << 8 | relPos.m_123343_() + 64 & 0xFF;
    }

    public static BlockPos decodeRelPos(int encoded) {
        return new BlockPos((encoded >> 16 & 0xFF) - 64, (encoded >> 8 & 0xFF) - 64, (encoded & 0xFF) - 64);
    }

    public static enum PosType {
        BRANCHES,
        LEAVES,
        ENDPOINTS;

    }

    public static class BlockStateWithConnections {
        private final BlockState blockState;
        private final int[] connections;

        public BlockStateWithConnections(BlockState blockState) {
            this.blockState = blockState;
            this.connections = new int[6];
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public int[] getConnections() {
            return this.connections;
        }
    }
}

