/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.pod;

import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.GrowableBlock;
import com.ferreusveritas.dynamictrees.block.OffsetablePodBlock;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.util.AgeProperties;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.OffsetProperties;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class Pod
extends RegistryEntry<Pod>
implements Resettable<Pod> {
    public static final TypedRegistry.EntryType<Pod> TYPE = TypedRegistry.newType(Pod::new);
    public static final Pod NULL = new Pod(DTTrees.NULL);
    public static final TypedRegistry<Pod> REGISTRY = new TypedRegistry<Pod>(Pod.class, NULL, TYPE);
    private Supplier<PodBlock> block;
    private int maxAge = 2;
    private IntegerProperty ageProperty = BlockStateProperties.f_61406_;
    private IntegerProperty offsetProperty;
    private final BlockShapeData blockShapeData = new BlockShapeData();
    private boolean canBoneMeal = true;
    private ItemStack itemStack;
    private float growthChance = 0.2f;
    @Nullable
    private Float seasonOffset = Float.valueOf(0.0f);
    private float flowerHoldPeriodLength = 0.5f;
    private float minProductionFactor = 0.3f;
    private int maxDropCount = 1;
    private int minDropCount = 1;
    private int minRadius = 8;
    private int maxRadius = 8;
    private GrowableBlock.MatureAction matureAction = GrowableBlock.MatureAction.DEFAULT;
    private final LazyValue<ResourceLocation> blockDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(ForgeRegistries.BLOCKS.getKey((Object)((Block)this.block.get())), "blocks/"));

    public Pod(ResourceLocation registryName) {
        super(registryName);
    }

    public final PodBlock getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("Invoked too early (before the block was created).");
        }
        return this.block.get();
    }

    public final void createBlock(@Nullable ResourceLocation name, BlockBehaviour.Properties properties) {
        this.block = RegistryHandler.addBlock(name == null ? this.getRegistryName() : name, () -> this.createBlock(properties));
    }

    protected PodBlock createBlock(BlockBehaviour.Properties properties) {
        if (this.hasVariableOffset()) {
            return new OffsetablePodBlock(properties, this);
        }
        return new PodBlock(properties, this);
    }

    public MapColor getDefaultMapColor() {
        return MapColor.f_283915_;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties() {
        return this.getDefaultBlockProperties(this.getDefaultMapColor());
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60910_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56758_).m_60977_().m_60978_(0.3f);
    }

    public final IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        this.ageProperty = AgeProperties.getOrCreate(maxAge);
    }

    public void setDropCount(int dropCount) {
        this.setMaxDropCount(dropCount);
        this.setMinDropCount(dropCount);
    }

    public void setMinDropCount(int minDropCount) {
        this.minDropCount = minDropCount;
    }

    public void setMaxDropCount(int maxDropCount) {
        this.maxDropCount = maxDropCount;
    }

    public final VoxelShape getBlockShape(Direction facing, int age) {
        return this.blockShapeData.getShapeFor(facing, age);
    }

    public void setBlockShapes(Direction facing, VoxelShape[] blockShapes) {
        this.blockShapeData.setShapesFor(facing, blockShapes);
    }

    public final boolean canBoneMeal() {
        return this.canBoneMeal;
    }

    public void setCanBoneMeal(boolean canBoneMeal) {
        this.canBoneMeal = canBoneMeal;
    }

    public final ItemStack getItemStack() {
        if (this.itemStack == null) {
            LogManager.getLogger().warn("Invoked too early or item was not set on \"" + String.valueOf(this.getRegistryName()) + "\".");
            return new ItemStack((ItemLike)Items.f_41852_);
        }
        return this.itemStack.m_41777_();
    }

    public boolean isItem(ItemStack itemStack) {
        return ItemStack.m_41728_((ItemStack)this.itemStack, (ItemStack)itemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public final float getGrowthChance() {
        return this.growthChance;
    }

    public void setGrowthChance(float growthChance) {
        this.growthChance = growthChance;
    }

    public boolean isInFlowerHoldPeriod(LevelAccessor level, BlockPos rootPos, Float seasonValue) {
        if (this.seasonOffset == null) {
            return false;
        }
        Float peakSeasonValue = SeasonHelper.getSeasonManager().getPeakFruitProductionSeasonValue(LevelContext.create(level).level(), rootPos, this.seasonOffset.floatValue());
        if (peakSeasonValue == null || this.flowerHoldPeriodLength == 0.0f) {
            return false;
        }
        float min = peakSeasonValue.floatValue() - 1.5f;
        float max = min + this.flowerHoldPeriodLength;
        return SeasonHelper.isSeasonBetween(seasonValue, min, max);
    }

    @Nullable
    public final Float getSeasonOffset() {
        return this.seasonOffset;
    }

    public void setSeasonOffset(@Nullable Float offset) {
        this.seasonOffset = offset;
    }

    public float seasonalProductionFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, pos, -this.seasonOffset.floatValue(), false) : 1.0f;
    }

    public float getFlowerHoldPeriodLength() {
        return this.flowerHoldPeriodLength;
    }

    public void setFlowerHoldPeriodLength(float flowerHoldPeriodLength) {
        this.flowerHoldPeriodLength = flowerHoldPeriodLength;
    }

    public final float getMinProductionFactor() {
        return this.minProductionFactor;
    }

    public void setMinProductionFactor(float minProductionFactor) {
        this.minProductionFactor = minProductionFactor;
    }

    public boolean isOutOfSeason(LevelContext levelContext, BlockPos pos) {
        return this.seasonalProductionFactor(levelContext, pos) < this.minProductionFactor;
    }

    public void place(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue, Direction facing, int radius) {
        BlockState state = this.getStateFor(facing, 0, radius);
        level.m_7731_(pos, state, 2);
    }

    public void placeDuringWorldGen(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue, Direction facing, int radius) {
        BlockState state = this.getStateFor(facing, this.getAgeForWorldGen(level, pos, seasonValue), radius);
        level.m_7731_(pos, state, 2);
    }

    protected BlockState getStateFor(Direction facing, int age, int radius) {
        if (age < 0) {
            throw new IllegalArgumentException("Cannot get state for negative pod age.");
        }
        if (age > this.maxAge) {
            throw new IllegalArgumentException("Cannot get state for age " + age + " as it is greater than maximum " + this.maxAge + " for pod \"" + String.valueOf(this.getRegistryName()) + "\".");
        }
        BlockState state = (BlockState)((BlockState)this.block.get().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing)).m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(age));
        if (this.hasVariableOffset() && state.m_61138_((Property)this.getOffsetProperty())) {
            state = (BlockState)state.m_61124_((Property)this.getOffsetProperty(), (Comparable)Integer.valueOf(radius));
        }
        return state;
    }

    protected int getAgeForWorldGen(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue) {
        if (seasonValue != null && this.isInFlowerHoldPeriod(level, pos, seasonValue)) {
            return 0;
        }
        return Math.min(level.m_213780_().m_188503_(this.maxAge * 2), this.maxAge);
    }

    public void performMatureAction(GrowableBlock.Info blockInfo) {
        this.matureAction.perform(this.block.get(), blockInfo);
    }

    public void setMatureAction(GrowableBlock.MatureAction matureAction) {
        this.matureAction = matureAction;
    }

    public boolean shouldGenerateBlockDrops() {
        return true;
    }

    public ResourceLocation getBlockDropsPath() {
        return this.blockDropsPath.get();
    }

    public LootTable.Builder createBlockDrops() {
        if (this.minDropCount > this.maxDropCount || this.maxDropCount <= 0) {
            throw new IllegalArgumentException("Attempted to create loot tables for " + String.valueOf(this.getRegistryName()) + " with an invalid drop count range [" + this.minDropCount + "," + this.maxDropCount + "].");
        }
        return DTLootTableProvider.BlockLoot.createFruitPodDrops((Block)this.block.get(), this.itemStack.m_41720_(), this.ageProperty, this.maxAge, this.minDropCount, this.maxDropCount);
    }

    public void setMaxRadius(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    public void setMinRadius(int minRadius) {
        this.minRadius = minRadius;
    }

    public boolean hasVariableOffset() {
        return this.minRadius != this.maxRadius;
    }

    public boolean isValidRadius(int radius) {
        return radius >= this.minRadius && radius <= this.maxRadius;
    }

    public IntegerProperty getOffsetProperty() {
        if (this.offsetProperty == null) {
            this.offsetProperty = OffsetProperties.getOrCreate(this.minRadius, this.maxRadius);
        }
        return this.offsetProperty;
    }

    @Override
    @Nonnull
    public Pod reset() {
        this.canBoneMeal = DTConfigs.SERVER_CONFIG.isLoaded() && (Boolean)DTConfigs.CAN_BONE_MEAL_PODS.get() != false;
        this.seasonOffset = Float.valueOf(0.0f);
        this.flowerHoldPeriodLength = 0.5f;
        this.minProductionFactor = 0.3f;
        this.matureAction = GrowableBlock.MatureAction.DEFAULT;
        return this;
    }

    public final class BlockShapeData {
        private final Map<Direction, VoxelShape[]> facingShapes = (Map)Util.m_137469_((Object)Maps.newHashMap(), facingShapes -> {
            facingShapes.put(Direction.NORTH, new VoxelShape[]{Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()});
            facingShapes.put(Direction.SOUTH, new VoxelShape[]{Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()});
            facingShapes.put(Direction.WEST, new VoxelShape[]{Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()});
            facingShapes.put(Direction.EAST, new VoxelShape[]{Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_(), Shapes.m_83144_()});
        });

        public VoxelShape getShapeFor(Direction facing, int age) {
            return this.facingShapes.get(facing)[age];
        }

        public void setShapesFor(Direction facing, VoxelShape[] shapes) {
            if (shapes.length <= Pod.this.maxAge) {
                throw new IllegalArgumentException("Insufficient number of block shapes provided for the maximum age " + Pod.this.maxAge + " on pod " + String.valueOf(this));
            }
            this.facingShapes.put(facing, shapes);
        }
    }
}

