/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AlternativeLeavesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<LeavesProperties> ALT_LEAVES = ConfigurationProperty.property("alternative_leaves", LeavesProperties.class);
    public static final ConfigurationProperty<Block> ALT_LEAVES_BLOCK = ConfigurationProperty.block("alternative_leaves_block");

    public AlternativeLeavesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(ALT_LEAVES, ALT_LEAVES_BLOCK, PLACE_CHANCE, QUANTITY);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_LEAVES, LeavesProperties.NULL)).with(ALT_LEAVES_BLOCK, Blocks.f_50016_)).with(PLACE_CHANCE, Float.valueOf(0.5f))).with(QUANTITY, 5);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        configuration.get(ALT_LEAVES).ifValid(properties -> {
            properties.setFamily(species.getFamily());
            species.addValidLeafBlocks((LeavesProperties)properties);
        });
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockBounds bounds = context.species().getFamily().expandLeavesBlockBounds(new BlockBounds(context.endPoints()));
        return this.setAltLeaves(configuration, context.level(), bounds, context.bounds(), context.species());
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor world = context.level();
        Species species = context.species();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(world, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        BlockPos chosenEndPoint = endPoints.get(world.m_213780_().m_188503_(endPoints.size()));
        BlockBounds bounds = species.getFamily().expandLeavesBlockBounds(new BlockBounds(chosenEndPoint));
        return this.setAltLeaves(configuration, world, bounds, SafeChunkBounds.ANY, species);
    }

    private Block getAltLeavesBlock(GenFeatureConfiguration conifuration) {
        LeavesProperties properties = conifuration.get(ALT_LEAVES);
        if (!properties.isValid() || !properties.getDynamicLeavesBlock().isPresent()) {
            return conifuration.get(ALT_LEAVES_BLOCK);
        }
        return (Block)properties.getDynamicLeavesBlock().get();
    }

    private BlockState getSwapBlockState(GenFeatureConfiguration configuration, LevelAccessor world, Species species, BlockState state, boolean worldgen) {
        DynamicLeavesBlock altLeaves;
        DynamicLeavesBlock originalLeaves = species.getLeavesBlock().orElse(null);
        Block alt = this.getAltLeavesBlock(configuration);
        DynamicLeavesBlock dynamicLeavesBlock = altLeaves = alt instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)alt : null;
        if (originalLeaves != null && altLeaves != null) {
            if (worldgen || world.m_213780_().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
                if (state.m_60734_() == originalLeaves) {
                    return altLeaves.properties.getDynamicLeavesState((Integer)state.m_61143_((Property)LeavesBlock.f_54418_));
                }
            } else if (state.m_60734_() == altLeaves) {
                return originalLeaves.properties.getDynamicLeavesState((Integer)state.m_61143_((Property)LeavesBlock.f_54418_));
            }
        }
        return state;
    }

    private boolean setAltLeaves(GenFeatureConfiguration configuration, LevelAccessor world, BlockBounds leafPositions, SafeChunkBounds safeBounds, Species species) {
        boolean worldGen;
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (worldGen) {
            AtomicBoolean isSet = new AtomicBoolean(false);
            leafPositions.iterator().forEachRemaining(pos -> {
                if (safeBounds.inBounds((BlockPos)pos, true) && world.m_213780_().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue() && world.m_7731_(pos, this.getSwapBlockState(configuration, world, species, world.m_8055_(pos), true), 2)) {
                    isSet.set(true);
                }
            });
            return isSet.get();
        }
        boolean isSet = false;
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        for (BlockPos leafPosition : leafPositions) {
            posList.add(new BlockPos((Vec3i)leafPosition));
        }
        if (posList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < (Integer)configuration.get(QUANTITY); ++i) {
            BlockPos pos2 = (BlockPos)posList.get(world.m_213780_().m_188503_(posList.size()));
            if (!world.m_7731_(pos2, this.getSwapBlockState(configuration, world, species, world.m_8055_(pos2), false), 2)) continue;
            isSet = true;
        }
        return isSet;
    }
}

