/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingTreeEntityModelTrackerCache {
    private static ConcurrentMap<Integer, FallingTreeEntityModel> models = new ConcurrentHashMap<Integer, FallingTreeEntityModel>();

    public static FallingTreeEntityModel getOrCreateModel(FallingTreeEntity entity) {
        return models.computeIfAbsent(entity.m_19879_(), e -> new FallingTreeEntityModel(entity));
    }

    public static void cleanupModels(Level level, FallingTreeEntity entity) {
        models.remove(entity.m_19879_());
        FallingTreeEntityModelTrackerCache.cleanupModels(level);
    }

    public static void cleanupModels(Level level) {
        models = models.entrySet().stream().filter(map -> level.m_6815_(((Integer)map.getKey()).intValue()) != null).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

