/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.entry;

import com.ferreusveritas.dynamictrees.loot.entry.DTLootPoolEntries;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public final class WeightedItemLootPoolEntry
extends LootPoolSingletonContainer {
    private final SimpleWeightedRandomList<Item> items;

    public WeightedItemLootPoolEntry(SimpleWeightedRandomList<Item> items, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)DTLootPoolEntries.WEIGHTED_ITEM.get();
    }

    protected void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        this.items.m_216820_(lootContext.m_230907_()).ifPresent(item -> stackConsumer.accept(new ItemStack((ItemLike)item)));
    }

    public static LootPoolSingletonContainer.Builder<?> weightedLootTableItem(SimpleWeightedRandomList<Item> items) {
        return WeightedItemLootPoolEntry.m_79687_((weight, quality, conditions, functions) -> new WeightedItemLootPoolEntry(items, weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<WeightedItemLootPoolEntry> {
        public void serializeCustom(JsonObject json, WeightedItemLootPoolEntry value, JsonSerializationContext conditions) {
            super.m_7219_(json, (LootPoolSingletonContainer)value, conditions);
            JsonObject weightedItemsJson = new JsonObject();
            value.items.m_146338_().forEach(entry -> weightedItemsJson.addProperty(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)((Item)entry.m_146310_()))), (Number)entry.m_142631_().m_146281_()));
            json.add("items", (JsonElement)weightedItemsJson);
        }

        protected WeightedItemLootPoolEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            JsonObject weightedItemsJson = GsonHelper.m_13930_((JsonObject)json, (String)"items");
            SimpleWeightedRandomList.Builder items = new SimpleWeightedRandomList.Builder();
            for (Map.Entry itemEntry : weightedItemsJson.entrySet()) {
                String name = (String)itemEntry.getKey();
                Item item = Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))).orElseThrow(() -> new JsonSyntaxException("Expected key to be an item, was unknown string '" + name + "'"));
                int itemWeight = GsonHelper.m_13897_((JsonElement)((JsonElement)itemEntry.getValue()), (String)name);
                items.m_146271_((Object)item, itemWeight);
            }
            return new WeightedItemLootPoolEntry((SimpleWeightedRandomList<Item>)items.m_146270_(), weight, quality, conditions, functions);
        }
    }
}

