/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entity;

import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.substance.LingeringSubstances;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class LingeringEffectorEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private BlockPos blockPos;
    private SubstanceEffect effect;
    private byte invalidTicks = 0;

    public LingeringEffectorEntity(EntityType<? extends LingeringEffectorEntity> entityTypeIn, Level level) {
        super(entityTypeIn, level);
        this.blockPos = BlockPos.f_121853_;
    }

    private LingeringEffectorEntity(Level level) {
        super(DTRegistries.LINGERING_EFFECTOR.get(), level);
    }

    public LingeringEffectorEntity(Level level, BlockPos pos, SubstanceEffect effect) {
        this(DTRegistries.LINGERING_EFFECTOR.get(), level);
        this.m_274367_(1.0f);
        this.f_19794_ = true;
        this.setBlockPos(pos);
        this.effect = effect;
        if (this.effect != null) {
            for (LingeringEffectorEntity effector : level.m_45976_(LingeringEffectorEntity.class, new AABB(pos))) {
                if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
                effector.m_6074_();
            }
        }
    }

    public static boolean treeHasEffectorForEffect(LevelAccessor level, BlockPos pos, SubstanceEffect effect) {
        for (LingeringEffectorEntity effector : level.m_45976_(LingeringEffectorEntity.class, new AABB(pos))) {
            if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
            return true;
        }
        return false;
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
        this.m_6034_((double)this.blockPos.m_123341_() + 0.5, this.blockPos.m_123342_(), (double)this.blockPos.m_123343_() + 0.5);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public SubstanceEffect getEffect() {
        return this.effect;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.effect == null) {
            this.invalidTicks = (byte)(this.invalidTicks + 1);
            if (this.invalidTicks > 20) {
                this.m_6074_();
            }
            return;
        }
        BlockState blockState = this.m_9236_().m_8055_(this.blockPos);
        if (blockState.m_60734_() instanceof RootyBlock) {
            if (!this.effect.update(this.m_9236_(), this.blockPos, this.f_19797_, (Integer)blockState.m_61143_((Property)RootyBlock.FERTILITY))) {
                this.m_6074_();
            }
        } else {
            this.m_6074_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.effect == null ? -1 : LingeringSubstances.indexOf(this.effect.getClass()));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        byte index = additionalData.readByte();
        SubstanceEffect substanceEffect = this.effect = index < 0 ? null : (SubstanceEffect)LingeringSubstances.fromIndex(index).get();
        if (this.effect != null && this.m_9236_() != null) {
            this.effect.apply(this.m_9236_(), this.blockPos);
        }
    }
}

