/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public final class DTRecipes {
    public static void registerDirtBucketRecipes(Map<ResourceLocation, Recipe<?>> craftingRecipes) {
        for (Species species : Species.REGISTRY.getAll()) {
            if (!species.hasSeed()) continue;
            ResourceLocation registryName = species.getRegistryName();
            if (((Boolean)DTConfigs.GENERATE_DIRT_BUCKET_RECIPES.get()).booleanValue()) {
                DTRecipes.generateSaplingRecipes(craftingRecipes, species, registryName);
            }
            if (!((Boolean)DTConfigs.GENERATE_MEGA_SEED_RECIPE.get()).booleanValue()) continue;
            DTRecipes.generateMegaSeedRecipes(craftingRecipes, species, registryName);
        }
    }

    private static void generateMegaSeedRecipes(Map<ResourceLocation, Recipe<?>> craftingRecipes, Species species, ResourceLocation registryName) {
        if (species.isMegaSpecies() && species.getPreMegaSpecies().hasSeed() && species.getPreMegaSpecies().canCraftMegaSeed()) {
            ResourceLocation resLoc = new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + "_mega_of_" + species.getPreMegaSpecies().getRegistryName().m_135815_());
            Item preMegaSeed = species.getPreMegaSpecies().getSeed().orElse(null);
            craftingRecipes.putIfAbsent(resLoc, (Recipe<?>)DTRecipes.createSquare(resLoc, species.getSeedStack(1), Ingredient.m_43929_((ItemLike[])new ItemLike[]{preMegaSeed})));
        }
    }

    private static void generateSaplingRecipes(Map<ResourceLocation, Recipe<?>> craftingRecipes, Species species, ResourceLocation registryName) {
        species.getPrimitiveSaplingRecipes().forEach(saplingRecipe -> {
            List<Item> ingredients;
            Item saplingItem = saplingRecipe.getSaplingItem().orElse(null);
            if (saplingItem == null || ForgeRegistries.ITEMS.getKey((Object)saplingItem) == null) {
                LogManager.getLogger().error("Error creating seed-sapling recipe for species \"" + String.valueOf(species.getRegistryName()) + "\" as sapling item does not exist.");
                return;
            }
            if (saplingRecipe.canCraftSaplingToSeed()) {
                ResourceLocation saplingToSeed = new ResourceLocation(registryName.m_135827_(), DTRecipes.separate(ForgeRegistries.ITEMS.getKey((Object)saplingItem)) + "_to_" + registryName.m_135815_() + "_seed");
                ingredients = saplingRecipe.getIngredientsForSaplingToSeed();
                ingredients.add(DTRegistries.DIRT_BUCKET.get());
                ingredients.add(saplingItem);
                craftingRecipes.putIfAbsent(saplingToSeed, (Recipe<?>)DTRecipes.createShapeless(saplingToSeed, species.getSeedStack(1), DTRecipes.ingredients(ingredients)));
            }
            if (saplingRecipe.canCraftSeedToSapling()) {
                ResourceLocation seedToSapling = new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + "_seed_to_" + DTRecipes.separate(ForgeRegistries.ITEMS.getKey((Object)saplingItem)));
                ingredients = saplingRecipe.getIngredientsForSeedToSapling();
                ingredients.add(DTRegistries.DIRT_BUCKET.get());
                ingredients.add(species.getSeed().map(Item.class::cast).orElse(Items.f_41852_));
                craftingRecipes.putIfAbsent(seedToSapling, (Recipe<?>)DTRecipes.createShapeless(seedToSapling, new ItemStack((ItemLike)saplingItem), DTRecipes.ingredients(ingredients)));
            }
        });
    }

    private static String separate(ResourceLocation resourceLocation) {
        return resourceLocation.m_135827_() + "_" + resourceLocation.m_135815_();
    }

    private static ShapelessRecipe createShapeless(ResourceLocation registryName, ItemStack out, Ingredient ... ingredients) {
        return new ShapelessRecipe(registryName, "CRAFTING_MISC", CraftingBookCategory.MISC, out, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    private static ShapedRecipe createSquare(ResourceLocation registryName, ItemStack out, Ingredient ingredient) {
        return new ShapedRecipe(registryName, "CRAFTING_MISC", CraftingBookCategory.MISC, 2, 2, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{ingredient, ingredient, ingredient, ingredient}), out);
    }

    private static Ingredient[] ingredients(Collection<Item> items) {
        return DTRecipes.ingredients(items.toArray(new Item[0]));
    }

    private static Ingredient[] ingredients(Item ... items) {
        if (items.length == 0) {
            return new Ingredient[]{Ingredient.f_43901_};
        }
        return Arrays.stream(items).map(item -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)})).collect(Collectors.toSet()).toArray(new Ingredient[0]);
    }
}

