/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import invtweaks.InvTweaksMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class Category {
    private final List<String> spec;
    private final List<List<Predicate<ItemStack>>> compiledSpec = new ArrayList<List<Predicate<ItemStack>>>();

    public Category(List<String> spec) {
        this.spec = spec;
        for (String subspec : spec) {
            ArrayList compiledSubspec = new ArrayList();
            for (String clause : subspec.split("\\s*;\\s*")) {
                Category.compileClause(clause).ifPresent(compiledSubspec::add);
            }
            this.compiledSpec.add(compiledSubspec);
        }
    }

    public Category(String ... spec) {
        this(Arrays.asList(spec));
    }

    private static Optional<Predicate<ItemStack>> compileClause(String clause) {
        if (clause.startsWith("!")) {
            return Category.compileClause(clause.substring(1)).map(Predicate::negate);
        }
        String[] parts = clause.split(":", 2);
        if (parts[0].equals("/tag")) {
            TagKey itemKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(parts[1]));
            TagKey blockKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation(parts[1]));
            return Optional.of(stack -> {
                BlockItem blockItem;
                Item patt1873$temp;
                return stack.m_204117_(itemKey) || (patt1873$temp = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)patt1873$temp).m_40614_().m_49966_().m_204336_(blockKey);
            });
        }
        if (parts[0].equals("/instanceof") || parts[0].equals("/class")) {
            try {
                Class<?> clazz = Class.forName(parts[1]);
                if (parts[0].equals("/instanceof")) {
                    return Optional.of(st -> clazz.isInstance(st.m_41720_()));
                }
                return Optional.of(st -> st.m_41720_().getClass().equals(clazz));
            }
            catch (ClassNotFoundException e) {
                InvTweaksMod.LOGGER.warn("Class not found! Ignoring clause " + clause);
                return Optional.empty();
            }
        }
        if (parts[0].equals("/isFood")) {
            return Optional.of(stack -> stack.getFoodProperties(null) != null);
        }
        try {
            return Optional.of(st -> Objects.equals(ForgeRegistries.ITEMS.getKey((Object)st.m_41720_()), new ResourceLocation(clause)));
        }
        catch (ResourceLocationException e) {
            InvTweaksMod.LOGGER.warn("Invalid item resource location found. " + clause);
            return Optional.empty();
        }
    }

    public int checkStack(ItemStack stack) {
        return IntStream.range(0, this.compiledSpec.size()).filter(idx -> this.compiledSpec.get(idx).stream().allMatch(pr -> pr.test(stack))).findFirst().orElse(-1);
    }

    public CommentedConfig toConfig(String catName) {
        CommentedConfig result = CommentedConfig.inMemory();
        result.set("name", (Object)catName);
        result.set("spec", this.spec);
        return result;
    }
}

