/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;

public class WallBuildingBlockObject
extends BuildingBlockObject {
    private final Supplier<? extends WallBlock> wall;

    public WallBuildingBlockObject(BuildingBlockObject object, Supplier<? extends WallBlock> wall) {
        super(object);
        this.wall = wall;
    }

    public WallBuildingBlockObject(BuildingBlockObject object, Block wall) {
        this(object, RegistrationHelper.getCastedHolder(BuiltInRegistries.f_256975_, wall));
    }

    public WallBlock getWall() {
        return Objects.requireNonNull(this.wall.get(), "Wall Building Block Object missing wall");
    }

    @Override
    public void forEach(Consumer<? super Block> consumer) {
        super.forEach(consumer);
        consumer.accept((Block)this.getWall());
    }

    @Override
    public List<Block> values() {
        return List.of((Block)this.get(), this.getSlab(), this.getStairs(), this.getWall());
    }
}

