/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.recipe.IMultiRecipe;

public class RecipeHelper {
    public static <C extends Recipe<?>> Optional<C> getRecipe(RecipeManager manager, ResourceLocation name, Class<C> clazz) {
        return manager.m_44043_(name).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <I extends Container, T extends Recipe<I>, C extends T> List<C> getRecipes(RecipeManager manager, RecipeType<T> type, Class<C> clazz) {
        return manager.m_44054_(type).values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends Container, T extends Recipe<I>, C extends T> List<C> getUIRecipes(RecipeManager manager, RecipeType<T> type, Class<C> clazz, Predicate<? super C> filter) {
        return manager.m_44054_(type).values().stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).sorted(Comparator.comparing(Recipe::m_6423_)).collect(Collectors.toList());
    }

    public static <C> List<C> getJEIRecipes(RegistryAccess access, Stream<? extends Recipe<?>> recipes, Class<C> clazz) {
        return recipes.sorted((r1, r2) -> {
            boolean m1 = r1 instanceof IMultiRecipe;
            boolean m2 = r2 instanceof IMultiRecipe;
            if (m1 && !m2) {
                return 1;
            }
            if (!m1 && m2) {
                return -1;
            }
            return r1.m_6423_().compareTo(r2.m_6423_());
        }).flatMap(recipe -> {
            if (recipe instanceof IMultiRecipe) {
                return ((IMultiRecipe)recipe).getRecipes(access).stream();
            }
            return Stream.of(recipe);
        }).filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends Container, T extends Recipe<I>, C> List<C> getJEIRecipes(RegistryAccess access, RecipeManager manager, RecipeType<T> type, Class<C> clazz) {
        return RecipeHelper.getJEIRecipes(access, manager.m_44054_(type).values().stream(), clazz);
    }

    private RecipeHelper() {
    }
}

