/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public final class SavedRoutesManager {
    private static final LinkedHashSet<ClientRoute> savedRoutes = new LinkedHashSet();
    private static Single.MutableSingle<Boolean> isSynchronizing = new Single.MutableSingle((Object)false);

    public static void saveRoute(ClientRoute route) {
        route.addListener();
        savedRoutes.add(route);
    }

    public static void removeRoute(ClientRoute route) {
        route.close();
        savedRoutes.remove(route);
    }

    public static void removeAllRoutes() {
        savedRoutes.forEach(x -> x.closeAll());
        savedRoutes.clear();
    }

    public static boolean isSaved(ClientRoute route) {
        return savedRoutes.contains(route);
    }

    public static List<ClientRoute> getAllSavedRoutes() {
        return new ArrayList<ClientRoute>(savedRoutes);
    }

    public static void push(boolean clear, Runnable andThen) {
        isSynchronizing.setFirst((Object)true);
        DataAccessor.getFromServer((Object)Minecraft.m_91087_().f_91074_.m_20148_(), ModAccessorTypes.GET_USER_SETTINGS, settings -> {
            Set<Object> currentValue = clear ? new HashSet() : settings.savedRoutes.getValue();
            currentValue.addAll(savedRoutes.stream().map(x -> x.toNbt()).toList());
            settings.savedRoutes.setValue(currentValue);
            settings.clientSave(() -> {
                isSynchronizing.setFirst((Object)false);
                DLUtils.doIfNotNull((Object)andThen, Runnable::run);
            });
        });
    }

    public static void pull(boolean clear, Runnable andThen) {
        isSynchronizing.setFirst((Object)true);
        DataAccessor.getFromServer((Object)Minecraft.m_91087_().f_91074_.m_20148_(), ModAccessorTypes.GET_USER_SETTINGS, settings -> {
            Set currentValue = settings.savedRoutes.getValue().stream().map(x -> ClientRoute.fromNbt(x, true)).collect(Collectors.toSet());
            if (clear) {
                savedRoutes.clear();
            }
            savedRoutes.addAll(currentValue);
            isSynchronizing.setFirst((Object)false);
            DLUtils.doIfNotNull((Object)andThen, Runnable::run);
        });
    }

    public static boolean isSynchronizing() {
        return (Boolean)isSynchronizing.getFirst();
    }
}

