/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.packet;

import com.getitemfromblock.create_tweaked_controllers.block.TweakedLecternControllerBlockEntity;
import com.getitemfromblock.create_tweaked_controllers.controller.ControllerRedstoneOutput;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedLinkedControllerServerHandler;
import com.getitemfromblock.create_tweaked_controllers.item.TweakedLinkedControllerItem;
import com.getitemfromblock.create_tweaked_controllers.packet.TweakedLinkedControllerPacketBase;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import java.util.ArrayList;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class TweakedLinkedControllerAxisPacket
extends TweakedLinkedControllerPacketBase {
    private int axis = 0;
    private float[] fullAxis;

    public TweakedLinkedControllerAxisPacket(int axisIn) {
        this(axisIn, null);
    }

    public TweakedLinkedControllerAxisPacket(int axisIn, BlockPos lecternPos) {
        super(lecternPos);
        this.axis = axisIn;
    }

    public TweakedLinkedControllerAxisPacket(float[] axisIn, int axisL, BlockPos lecternPos) {
        super(lecternPos);
        this.useFullPrecision = true;
        this.fullAxis = new float[6];
        this.axis = axisL;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.fullAxis[i] = axisIn[i];
        }
    }

    public TweakedLinkedControllerAxisPacket(FriendlyByteBuf buffer) {
        super(buffer);
        if (this.useFullPrecision) {
            this.fullAxis = new float[6];
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.fullAxis[i] = buffer.readFloat();
            }
        }
        this.axis = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        if (this.useFullPrecision) {
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                buffer.writeFloat(this.fullAxis[i]);
            }
        }
        buffer.writeInt(this.axis);
    }

    @Override
    protected void handleLectern(ServerPlayer player, TweakedLecternControllerBlockEntity lectern) {
        if (lectern.isUsedBy((Player)player)) {
            this.handleItem(player, lectern.getController());
            if (this.useFullPrecision) {
                lectern.ReceiveFullStates(this.fullAxis);
            } else {
                lectern.ReceiveAxisStates(this.axis);
            }
        }
    }

    @Override
    protected void handleItem(ServerPlayer player, ItemStack heldItem) {
        Level world = player.m_20193_();
        UUID uniqueID = player.m_20148_();
        BlockPos pos = player.m_20183_();
        if (player.m_5833_()) {
            return;
        }
        ControllerRedstoneOutput output = new ControllerRedstoneOutput();
        output.DecodeAxis(this.axis);
        ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>> axisCouples = new ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>>(10);
        ArrayList<Byte> axisValues = new ArrayList<Byte>(10);
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            axisCouples.add(TweakedLinkedControllerItem.toFrequency(heldItem, i + 15));
            byte dt = 0;
            if (i < 8) {
                boolean hasHighBit;
                if (i % 2 == 1 == (hasHighBit = (output.axis[i / 2] & 0x10) != 0)) {
                    dt = (byte)(output.axis[i / 2] & 0xF);
                }
            } else {
                dt = output.axis[i - 4];
            }
            axisValues.add(dt);
        }
        TweakedLinkedControllerServerHandler.ReceiveAxis((LevelAccessor)world, pos, uniqueID, axisCouples, axisValues);
    }
}

