/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.common.Util;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] bs, int i, int j, int k) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(bs, i, j);
        long l = cRC32.getValue();
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((byte)(l >>> i2 * 8) == bs[k + i2]) continue;
            return false;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] bs) throws IOException {
        for (int i = 0; i < XZ.HEADER_MAGIC.length; ++i) {
            if (bs[i] == XZ.HEADER_MAGIC[i]) continue;
            throw new XZFormatException();
        }
        if (!DecoderUtil.isCRC32Valid(bs, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(bs, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] bs) throws IOException {
        StreamFlags streamFlags;
        if (bs[10] != XZ.FOOTER_MAGIC[0] || bs[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(bs, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(bs, 8);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        for (int i = 0; i < 4; ++i) {
            streamFlags.backwardSize |= (long)((bs[i + 4] & 0xFF) << i * 8);
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] bs, int i) throws UnsupportedOptionsException {
        if (bs[i] != 0 || (bs[i + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = bs[i + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags streamFlags, StreamFlags streamFlags2) {
        return streamFlags.checkType == streamFlags2.checkType;
    }

    public static long decodeVLI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        long l = n & 0x7F;
        int n2 = 0;
        while ((n & 0x80) != 0) {
            if (++n2 >= 9) {
                throw new CorruptedInputException();
            }
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 0) {
                throw new CorruptedInputException();
            }
            l |= (long)(n & 0x7F) << n2 * 7;
        }
        return l;
    }
}

