/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class DhApplyShader
extends AbstractShaderRenderer {
    public static DhApplyShader INSTANCE = new DhApplyShader();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public int gDhColorTextureUniform;
    public int gDepthMapUniform;

    private DhApplyShader() {
    }

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/apply.frag", "fragColor", new String[]{"vPosition"});
        this.gDhColorTextureUniform = this.shader.getUniformLocation("gDhColorTexture");
        this.gDepthMapUniform = this.shader.getUniformLocation("gDhDepthTexture");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
    }

    @Override
    protected void onRender() {
        if (MC_RENDER.mcRendersToFrameBuffer()) {
            this.renderToFrameBuffer();
        } else {
            this.renderToMcTexture();
        }
    }

    private void renderToFrameBuffer() {
        int targetFrameBuffer = MC_RENDER.getTargetFrameBuffer();
        if (targetFrameBuffer == -1) {
            return;
        }
        GLState state = new GLState();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(LodRenderer.getActiveColorTextureId());
        GL32.glUniform1i((int)this.gDhColorTextureUniform, (int)0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.gDepthMapUniform, (int)1);
        GLMC.glBindFramebuffer(36160, targetFrameBuffer);
        ScreenQuad.INSTANCE.render();
        state.restore();
        GLMC.glBindFramebuffer(36160, targetFrameBuffer);
    }

    private void renderToMcTexture() {
        int targetColorTextureId = MC_RENDER.getColorTextureId();
        if (targetColorTextureId == -1) {
            return;
        }
        int dhFrameBufferId = LodRenderer.getActiveFramebufferId();
        if (dhFrameBufferId == -1) {
            return;
        }
        int mcFrameBufferId = MC_RENDER.getTargetFrameBuffer();
        if (mcFrameBufferId == -1) {
            return;
        }
        GLState state = new GLState();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(LodRenderer.getActiveColorTextureId());
        GL32.glUniform1i((int)this.gDhColorTextureUniform, (int)0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.gDepthMapUniform, (int)1);
        GL32.glFramebufferTexture((int)36009, (int)36064, (int)targetColorTextureId, (int)0);
        GLMC.glBindFramebuffer(36160, dhFrameBufferId);
        ScreenQuad.INSTANCE.render();
        state.restore();
        GLMC.glBindFramebuffer(36160, mcFrameBufferId);
    }
}

