/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render;

import com.google.common.cache.Cache;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedColumnRenderSource
implements AutoCloseable {
    public final CompletableFuture<CachedColumnRenderSource> loadFuture;
    @Nullable
    public ColumnRenderSource columnRenderSource = null;
    private final AtomicInteger referenceCount;
    private final Cache<Long, CachedColumnRenderSource> cachedRenderSourceByPos;
    private final ReentrantLock getterLock;

    public CachedColumnRenderSource(@NotNull CompletableFuture<CachedColumnRenderSource> loadFuture, @NotNull ReentrantLock getterLock, @NotNull Cache<Long, CachedColumnRenderSource> cachedRenderSourceByPos) {
        this.loadFuture = loadFuture;
        this.getterLock = getterLock;
        this.referenceCount = new AtomicInteger(1);
        this.cachedRenderSourceByPos = cachedRenderSourceByPos;
    }

    public void markInUse() {
        this.referenceCount.getAndIncrement();
    }

    @Override
    public void close() throws IllegalStateException {
        try {
            this.getterLock.lock();
            if (this.columnRenderSource == null) {
                return;
            }
            int refCount = this.referenceCount.decrementAndGet();
            if (refCount == 0) {
                this.cachedRenderSourceByPos.invalidate((Object)this.columnRenderSource.pos);
                this.columnRenderSource.close();
            } else if (refCount < 0) {
                throw new IllegalStateException("Render source [" + this.columnRenderSource.pos + "] reference count incorrect. Object already closed.");
            }
        }
        finally {
            this.getterLock.unlock();
        }
    }
}

