/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ColorHex {
    private static final Pattern COLOR_HEX = Pattern.compile("^#([0-9A-Fa-f]{6})$");

    public static float[] colorTextToRbgFloatArray(String colorText) {
        int colorHex = ColorHex.colorTextToRbgInt(colorText);
        float r = (float)(colorHex >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorHex >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorHex & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int colorTextToRbgInt(String colorText) {
        Matcher matcher = COLOR_HEX.matcher(colorText);
        if (!matcher.find()) {
            return 0xFFFFFF;
        }
        return Integer.parseInt(matcher.group(1), 16);
    }
}

