/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunReload;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LivingEntityReload {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityReload(LivingEntity shooter, ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void reload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        ResourceLocation gunId = gunItem.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (gunItem.useInventoryAmmo(currentGunItem)) {
                return;
            }
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.isBolting) {
                return;
            }
            if (IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo() && !gunItem.canReload(this.shooter, currentGunItem)) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
                return;
            }
            NetworkHandler.sendToTrackingEntity(new ServerMessageGunReload(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = gunItem.getCurrentAmmoCount(currentGunItem) + (gunItem.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            this.data.reloadStateType = ammoCount <= 0 ? ReloadState.StateType.EMPTY_RELOAD_FEEDING : ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
            this.data.reloadTimestamp = System.currentTimeMillis();
            if (!gunItem.startReload(this.data, currentGunItem, this.shooter)) {
                this.data.reloadStateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        });
    }

    public void cancelReload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        if (!this.data.reloadStateType.isReloading()) {
            return;
        }
        gunItem.interruptReload(this.data, currentGunItem, this.shooter);
    }

    public ReloadState tickReloadState() {
        Item item;
        ItemStack currentGunItem;
        ReloadState result = new ReloadState();
        if (this.data.reloadTimestamp == -1L) {
            return result;
        }
        if (this.data.currentGunItem != null && (currentGunItem = this.data.currentGunItem.get()) != null && (item = currentGunItem.m_41720_()) instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)item;
            result = abstractGunItem.tickReload(this.data, currentGunItem, this.shooter);
        }
        this.data.reloadStateType = result.getStateType();
        if (!result.getStateType().isReloading()) {
            this.data.reloadTimestamp = -1L;
        }
        return result;
    }
}

