/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.index.ClientAttachmentSkinIndex;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentLod;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.AttachmentIndexPOJO;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.util.ColorHex;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ClientAttachmentIndex {
    private final Map<ResourceLocation, ClientAttachmentSkinIndex> skinIndexMap = Maps.newHashMap();
    private String name;
    @Nullable
    private BedrockAttachmentModel attachmentModel;
    @Nullable
    private ResourceLocation modelTexture;
    @Nullable
    private Pair<BedrockAttachmentModel, ResourceLocation> lodModel;
    private ResourceLocation slotTexture;
    private AttachmentData data;
    private float[] viewsFov;
    private float @Nullable [] zoom;
    private int[] views;
    private boolean isScope;
    private boolean isSight;
    private boolean showMuzzle;
    @Nullable
    private String adapterNodeName;
    @Nullable
    private String tooltipKey;
    private Map<String, ResourceLocation> sounds;
    @Nullable
    private LaserConfig laserConfig;

    private ClientAttachmentIndex() {
    }

    public static ClientAttachmentIndex getInstance(ResourceLocation registryName, AttachmentIndexPOJO indexPOJO) throws IllegalArgumentException {
        ClientAttachmentIndex index = new ClientAttachmentIndex();
        ClientAttachmentIndex.checkIndex(indexPOJO, index);
        AttachmentDisplay display = ClientAttachmentIndex.checkDisplay(indexPOJO, index);
        ClientAttachmentIndex.checkData(indexPOJO, index);
        ClientAttachmentIndex.checkName(indexPOJO, index);
        ClientAttachmentIndex.checkSlotTexture(display, index);
        ClientAttachmentIndex.checkTextureAndModel(display, index);
        ClientAttachmentIndex.checkTextShow(display, index.attachmentModel);
        ClientAttachmentIndex.checkLod(display, index);
        ClientAttachmentIndex.checkSounds(display, index);
        return index;
    }

    private static void checkIndex(AttachmentIndexPOJO attachmentIndexPOJO, ClientAttachmentIndex index) {
        Preconditions.checkArgument((attachmentIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        index.tooltipKey = attachmentIndexPOJO.getTooltip();
    }

    @Nonnull
    private static AttachmentDisplay checkDisplay(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        ResourceLocation pojoDisplay = indexPOJO.getDisplay();
        Preconditions.checkArgument((pojoDisplay != null ? 1 : 0) != 0, (Object)"index object missing display field");
        AttachmentDisplay display = ClientAssetsManager.INSTANCE.getAttachmentDisplay(pojoDisplay);
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        index.viewsFov = display.getViewsFov();
        if (index.viewsFov == null) {
            Preconditions.checkArgument((display.getFov() > 0.0f ? 1 : 0) != 0, (Object)"fov must > 0");
            index.viewsFov = new float[]{display.getFov()};
        } else {
            for (float fov : index.viewsFov) {
                Preconditions.checkArgument((fov > 0.0f ? 1 : 0) != 0, (Object)"fov must > 0");
            }
        }
        index.zoom = display.getZoom();
        if (index.zoom != null) {
            for (int i = 0; i < index.zoom.length; ++i) {
                if (!(index.zoom[i] < 1.0f)) continue;
                throw new IllegalArgumentException("zoom must >= 1");
            }
        }
        index.views = display.getViews();
        if (index.views == null) {
            index.views = new int[]{1};
        } else {
            for (int i = 0; i < index.views.length; ++i) {
                if (index.views[i] >= 1) continue;
                throw new IllegalArgumentException("view index must >= 1");
            }
        }
        index.isScope = display.isScope();
        index.isSight = display.isSight();
        index.adapterNodeName = display.getAdapterNodeName();
        index.showMuzzle = display.isShowMuzzle();
        index.laserConfig = display.getLaserConfig();
        return display;
    }

    private static void checkTextShow(AttachmentDisplay display, BedrockAttachmentModel model) {
        if (model != null) {
            HashMap textShowMap = Maps.newHashMap();
            display.getTextShows().forEach((key, textShow) -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
                    int color = ColorHex.colorTextToRbgInt(textShow.getColorText());
                    textShow.setColorInt(color);
                    textShowMap.put(key, textShow);
                }
            });
            model.setTextShowList(textShowMap);
        }
    }

    private static void checkData(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        ResourceLocation dataId = indexPOJO.getData();
        Preconditions.checkArgument((dataId != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        AttachmentData data = CommonAssetsManager.get().getAttachmentData(dataId);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.data = data;
    }

    private static void checkName(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        index.name = indexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    private static void checkSlotTexture(AttachmentDisplay display, ClientAttachmentIndex index) {
        index.slotTexture = Objects.requireNonNullElseGet(display.getSlotTextureLocation(), MissingTextureAtlasSprite::m_118071_);
    }

    private static void checkTextureAndModel(AttachmentDisplay display, ClientAttachmentIndex index) {
        index.attachmentModel = ClientAttachmentIndex.getOrLoadAttachmentModel(display.getModel());
        if (index.attachmentModel != null) {
            index.attachmentModel.setIsScope(display.isScope());
            index.attachmentModel.setIsSight(display.isSight());
        }
        index.modelTexture = display.getTexture();
    }

    @Nullable
    public static BedrockAttachmentModel getOrLoadAttachmentModel(@Nullable ResourceLocation modelLocation) {
        if (modelLocation == null) {
            return null;
        }
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(modelLocation);
        if (modelPOJO == null) {
            return null;
        }
        return ClientAttachmentIndex.getAttachmentModel(modelPOJO);
    }

    @Nullable
    public static BedrockAttachmentModel getAttachmentModel(BedrockModelPOJO modelPOJO) {
        BedrockAttachmentModel attachmentModel = null;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
        }
        return attachmentModel;
    }

    private static void checkLod(AttachmentDisplay display, ClientAttachmentIndex index) {
        AttachmentLod gunLod = display.getAttachmentLod();
        if (gunLod != null) {
            BedrockAttachmentModel model;
            ResourceLocation texture = gunLod.getModelTexture();
            if (gunLod.getModelLocation() == null) {
                return;
            }
            if (texture == null) {
                return;
            }
            BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(gunLod.getModelLocation());
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                model = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                model = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
        }
    }

    private static void checkSounds(AttachmentDisplay display, ClientAttachmentIndex index) {
        Map<String, ResourceLocation> displaySounds = display.getSounds();
        if (displaySounds == null) {
            index.sounds = Maps.newHashMap();
            return;
        }
        index.sounds = displaySounds;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTooltipKey() {
        return this.tooltipKey;
    }

    @Nullable
    public BedrockAttachmentModel getAttachmentModel() {
        return this.attachmentModel;
    }

    @Nullable
    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    @Nullable
    public Pair<BedrockAttachmentModel, ResourceLocation> getLodModel() {
        return this.lodModel;
    }

    public ResourceLocation getSlotTexture() {
        return this.slotTexture;
    }

    public float[] getViewsFov() {
        return this.viewsFov;
    }

    public float @Nullable [] getZoom() {
        return this.zoom;
    }

    public int[] getViews() {
        return this.views;
    }

    public AttachmentData getData() {
        return this.data;
    }

    @Deprecated
    @Nullable
    public ClientAttachmentSkinIndex getSkinIndex(@Nullable ResourceLocation skinName) {
        return null;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public boolean isSight() {
        return this.isSight;
    }

    @Nullable
    public String getAdapterNodeName() {
        return this.adapterNodeName;
    }

    public boolean isShowMuzzle() {
        return this.showMuzzle;
    }

    public Map<String, ResourceLocation> getSounds() {
        return this.sounds;
    }

    @Nullable
    public LaserConfig getLaserConfig() {
        return this.laserConfig;
    }
}

