/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.gui.components.refit.IStackTooltip;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GunAttachmentSlot
extends Button
implements IStackTooltip {
    private final AttachmentType type;
    private final Inventory inventory;
    private final int gunItemIndex;
    private final String nameKey;
    private boolean selected = false;
    private ItemStack attachmentItem = ItemStack.f_41583_;

    public GunAttachmentSlot(int pX, int pY, AttachmentType type, int gunItemIndex, Inventory inventory, Button.OnPress onPress) {
        super(pX, pY, 18, 18, (Component)Component.m_237119_(), onPress, Button.f_252438_);
        this.type = type;
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.nameKey = String.format("tooltip.tacz.attachment.%s", type.name().toLowerCase(Locale.US));
    }

    @Override
    public void renderTooltip(Consumer<ItemStack> consumer) {
        if (this.m_198029_() && !this.attachmentItem.m_41619_()) {
            consumer.accept(this.attachmentItem);
        }
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack gunItem;
        IGun iGun;
        if (this.m_198029_()) {
            Font font = Minecraft.m_91087_().f_91062_;
            int yOffset = this.m_252907_() + 20;
            if (this.selected && !this.attachmentItem.m_41619_()) {
                yOffset = this.m_252907_() + 30;
            }
            graphics.m_280653_(font, (Component)Component.m_237115_((String)this.nameKey), this.m_252754_() + this.m_5711_() / 2, yOffset, ChatFormatting.WHITE.m_126665_().intValue());
        }
        if ((iGun = IGun.getIGunOrNull(gunItem = this.inventory.m_8020_(this.gunItemIndex))) == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        int x = this.m_252754_();
        int y = this.m_252907_();
        if (this.m_198029_() || this.selected) {
            graphics.m_280163_(GunRefitScreen.SLOT_TEXTURE, x, y, 0.0f, 0.0f, this.f_93618_, this.f_93619_, 18, 18);
        } else {
            graphics.m_280163_(GunRefitScreen.SLOT_TEXTURE, x + 1, y + 1, 1.0f, 1.0f, this.f_93618_ - 2, this.f_93619_ - 2, 18, 18);
        }
        this.attachmentItem = iGun.getAttachment(gunItem, this.type);
        if (!this.attachmentItem.m_41619_()) {
            graphics.m_280480_(this.attachmentItem, x + 1, y + 1);
        } else {
            int xOffset = GunRefitScreen.getSlotTextureXOffset(gunItem, this.type);
            graphics.m_280411_(GunRefitScreen.ICONS_TEXTURE, x + 2, y + 2, this.f_93618_ - 4, this.f_93619_ - 4, (float)xOffset, 0.0f, 32, 32, GunRefitScreen.getSlotsTextureWidth(), 32);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public ItemStack getAttachmentItem() {
        ItemStack gunItem = this.inventory.m_8020_(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return ItemStack.f_41583_;
        }
        return iGun.getAttachment(gunItem, this.type);
    }

    public boolean isAllow() {
        ItemStack gunItem = this.inventory.m_8020_(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return false;
        }
        return iGun.allowAttachmentType(gunItem, this.type);
    }
}

