/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.resource;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public abstract class JsonResourceLoader<T> {
    private final Marker marker;
    private final Pattern pattern;
    private final String domain;
    private final Class<T> dataClass;

    public JsonResourceLoader(Class<T> dataClass, String marker, String domain) {
        this.dataClass = dataClass;
        this.marker = MarkerManager.getMarker((String)marker);
        this.domain = domain;
        this.pattern = Pattern.compile("^(\\w+)/" + domain + "/([\\w/]+)\\.json$");
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = this.pattern.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(this.marker, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    ResourceLocation registryName = new ResourceLocation(namespace, path);
                    String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    this.resolveJson(registryName, json);
                    bl = true;
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(this.marker, "Failed to read file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public void load(File root) {
        Path filePath = root.toPath().resolve(this.domain);
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    this.resolveJson((ResourceLocation)id, json);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(this.marker, "Failed to read file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(this.marker, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }

    public abstract void resolveJson(ResourceLocation var1, String var2);
}

