/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod;

import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import io.github.thatpreston.mermod.Mermod;
import io.github.thatpreston.mermod.client.render.TailStyle;
import io.github.thatpreston.mermod.client.render.model.TailLayerDefinitions;
import io.github.thatpreston.mermod.compat.MermodClothConfigScreen;
import io.github.thatpreston.mermod.compat.MermodFiguraAPI;
import io.github.thatpreston.mermod.registry.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public class MermodClient {
    public static final List<ModelLayerLocation> TAIL_MODEL_LAYERS = new ArrayList<ModelLayerLocation>();
    public static final ModelLayerLocation DEFAULT_TAIL_LAYER = MermodClient.createTailModelLayer("default_tail");
    public static final ModelLayerLocation H2O_TAIL_LAYER = MermodClient.createTailModelLayer("h2o_tail");
    public static final ModelLayerLocation SIREN_TAIL_LAYER = MermodClient.createTailModelLayer("siren_tail");

    public static void init() {
        MermodClient.registerConfigScreen();
        ItemLike[] itemLikeArray = new ItemLike[1];
        itemLikeArray[0] = () -> RegistryHandler.SEA_NECKLACE.get();
        ColorHandlerRegistry.registerItemColors((stack, index) -> index > 0 ? Mermod.getItemColor(stack) : -1, (ItemLike[])itemLikeArray);
        ItemLike[] itemLikeArray2 = new ItemLike[2];
        itemLikeArray2[0] = () -> RegistryHandler.MERMAID_BRA_MODIFIER.get();
        itemLikeArray2[1] = () -> RegistryHandler.TAIL_GRADIENT_MODIFIER.get();
        ColorHandlerRegistry.registerItemColors((stack, index) -> Mermod.getItemColor(stack), (ItemLike[])itemLikeArray2);
        EntityModelLayerRegistry.register((ModelLayerLocation)DEFAULT_TAIL_LAYER, () -> TailLayerDefinitions.getDefault(false));
        EntityModelLayerRegistry.register((ModelLayerLocation)H2O_TAIL_LAYER, () -> TailLayerDefinitions.getDefault(true));
        EntityModelLayerRegistry.register((ModelLayerLocation)SIREN_TAIL_LAYER, TailLayerDefinitions::getSiren);
    }

    private static ModelLayerLocation createTailModelLayer(String name) {
        ModelLayerLocation location = new ModelLayerLocation(new ResourceLocation("mermod", name), "main");
        TAIL_MODEL_LAYERS.add(location);
        return location;
    }

    private static void registerConfigScreen() {
        if (!Platform.isFabric() && Platform.isModLoaded((String)"cloth_config")) {
            Platform.getMod((String)"mermod").registerConfigurationScreen(MermodClothConfigScreen::build);
        }
    }

    public static boolean shouldTryRenderingTail(Player player) {
        if (!player.m_20145_()) {
            return !Mermod.figuraLoaded || MermodFiguraAPI.isTailVisible(player.m_20148_());
        }
        return false;
    }

    public static TailStyle getRenderedTailStyle(Player player) {
        TailStyle style;
        if (MermodClient.shouldTryRenderingTail(player) && (style = Mermod.getTailStyle(player)) != null && (player.m_20069_() || style.permanent())) {
            return style;
        }
        return null;
    }

    public static boolean shouldRenderTail(Player player) {
        if (player.m_20069_()) {
            return MermodClient.shouldTryRenderingTail(player) && Mermod.hasTailStyle(player);
        }
        return MermodClient.getRenderedTailStyle(player) != null;
    }
}

